/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless.ir;

import io.lucenia.painless.ClassWriter;
import io.lucenia.painless.Location;
import io.lucenia.painless.MethodWriter;
import io.lucenia.painless.ir.LoopNode;
import io.lucenia.painless.lookup.PainlessCast;
import io.lucenia.painless.lookup.PainlessLookupUtility;
import io.lucenia.painless.phase.IRTreeVisitor;
import io.lucenia.painless.symbol.WriteScope;
import org.objectweb.asm.Label;

public class ForEachSubArrayNode
extends LoopNode {
    private Class<?> variableType;
    private String variableName;
    private PainlessCast cast;
    private Class<?> arrayType;
    private String arrayName;
    private Class<?> indexType;
    private String indexName;
    private Class<?> indexedType;

    public void setVariableType(Class<?> variableType) {
        this.variableType = variableType;
    }

    public Class<?> getVariableType() {
        return this.variableType;
    }

    public String getVariableCanonicalTypeName() {
        return PainlessLookupUtility.typeToCanonicalTypeName(this.variableType);
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setCast(PainlessCast cast) {
        this.cast = cast;
    }

    public PainlessCast getCast() {
        return this.cast;
    }

    public void setArrayType(Class<?> arrayType) {
        this.arrayType = arrayType;
    }

    public Class<?> getArrayType() {
        return this.arrayType;
    }

    public String getArrayCanonicalTypeName() {
        return PainlessLookupUtility.typeToCanonicalTypeName(this.arrayType);
    }

    public void setArrayName(String arrayName) {
        this.arrayName = arrayName;
    }

    public String getArrayName() {
        return this.arrayName;
    }

    public void setIndexType(Class<?> indexType) {
        this.indexType = indexType;
    }

    public Class<?> getIndexType() {
        return this.indexType;
    }

    public String getIndexCanonicalTypeName() {
        return PainlessLookupUtility.typeToCanonicalTypeName(this.indexType);
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexedType(Class<?> indexedType) {
        this.indexedType = indexedType;
    }

    public Class<?> getIndexedType() {
        return this.indexedType;
    }

    public String getIndexedCanonicalTypeName() {
        return PainlessLookupUtility.typeToCanonicalTypeName(this.indexedType);
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitForEachSubArrayLoop(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        this.getConditionNode().visit(irTreeVisitor, scope);
        this.getBlockNode().visit(irTreeVisitor, scope);
    }

    public ForEachSubArrayNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        methodWriter.writeStatementOffset(this.getLocation());
        WriteScope.Variable variable = writeScope.defineVariable(this.variableType, this.variableName);
        WriteScope.Variable array = writeScope.defineInternalVariable(this.arrayType, this.arrayName);
        WriteScope.Variable index = writeScope.defineInternalVariable(this.indexType, this.indexName);
        this.getConditionNode().write(classWriter, methodWriter, writeScope);
        methodWriter.visitVarInsn(array.getAsmType().getOpcode(54), array.getSlot());
        methodWriter.push(-1);
        methodWriter.visitVarInsn(index.getAsmType().getOpcode(54), index.getSlot());
        Label begin = new Label();
        Label end = new Label();
        methodWriter.mark(begin);
        methodWriter.visitIincInsn(index.getSlot(), 1);
        methodWriter.visitVarInsn(index.getAsmType().getOpcode(21), index.getSlot());
        methodWriter.visitVarInsn(array.getAsmType().getOpcode(21), array.getSlot());
        methodWriter.arrayLength();
        methodWriter.ifICmp(156, end);
        methodWriter.visitVarInsn(array.getAsmType().getOpcode(21), array.getSlot());
        methodWriter.visitVarInsn(index.getAsmType().getOpcode(21), index.getSlot());
        methodWriter.arrayLoad(MethodWriter.getType(this.indexedType));
        methodWriter.writeCast(this.cast);
        methodWriter.visitVarInsn(variable.getAsmType().getOpcode(54), variable.getSlot());
        WriteScope.Variable loop = writeScope.getInternalVariable("loop");
        if (loop != null) {
            methodWriter.writeLoopCounter(loop.getSlot(), this.getLocation());
        }
        this.getBlockNode().continueLabel = begin;
        this.getBlockNode().breakLabel = end;
        this.getBlockNode().write(classWriter, methodWriter, writeScope);
        methodWriter.goTo(begin);
        methodWriter.mark(end);
    }
}

