/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless.ir;

import io.lucenia.painless.ClassWriter;
import io.lucenia.painless.Location;
import io.lucenia.painless.MethodWriter;
import io.lucenia.painless.ir.DeclarationBlockNode;
import io.lucenia.painless.ir.ExpressionNode;
import io.lucenia.painless.ir.IRNode;
import io.lucenia.painless.ir.LoopNode;
import io.lucenia.painless.phase.IRTreeVisitor;
import io.lucenia.painless.symbol.WriteScope;
import org.objectweb.asm.Label;

public class ForLoopNode
extends LoopNode {
    private IRNode initializerNode;
    private ExpressionNode afterthoughtNode;

    public void setInitialzerNode(IRNode initializerNode) {
        this.initializerNode = initializerNode;
    }

    public IRNode getInitializerNode() {
        return this.initializerNode;
    }

    public void setAfterthoughtNode(ExpressionNode afterthoughtNode) {
        this.afterthoughtNode = afterthoughtNode;
    }

    public ExpressionNode getAfterthoughtNode() {
        return this.afterthoughtNode;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitForLoop(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        if (this.initializerNode != null) {
            this.initializerNode.visit(irTreeVisitor, scope);
        }
        if (this.getConditionNode() != null) {
            this.getConditionNode().visit(irTreeVisitor, scope);
        }
        if (this.afterthoughtNode != null) {
            this.afterthoughtNode.visit(irTreeVisitor, scope);
        }
        if (this.getBlockNode() != null) {
            this.getBlockNode().visit(irTreeVisitor, scope);
        }
    }

    public ForLoopNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        WriteScope.Variable loop;
        methodWriter.writeStatementOffset(this.getLocation());
        writeScope = writeScope.newScope();
        Label start = new Label();
        Label begin = this.afterthoughtNode == null ? start : new Label();
        Label end = new Label();
        if (this.initializerNode instanceof DeclarationBlockNode) {
            this.initializerNode.write(classWriter, methodWriter, writeScope);
        } else if (this.initializerNode instanceof ExpressionNode) {
            ExpressionNode initializer = (ExpressionNode)this.initializerNode;
            initializer.write(classWriter, methodWriter, writeScope);
            methodWriter.writePop(MethodWriter.getType(initializer.getExpressionType()).getSize());
        }
        methodWriter.mark(start);
        if (this.getConditionNode() != null && !this.isContinuous()) {
            this.getConditionNode().write(classWriter, methodWriter, writeScope);
            methodWriter.ifZCmp(153, end);
        }
        if ((loop = writeScope.getInternalVariable("loop")) != null) {
            methodWriter.writeLoopCounter(loop.getSlot(), this.getLocation());
        }
        boolean allEscape = false;
        if (this.getBlockNode() != null) {
            allEscape = this.getBlockNode().doAllEscape();
            this.getBlockNode().continueLabel = begin;
            this.getBlockNode().breakLabel = end;
            this.getBlockNode().write(classWriter, methodWriter, writeScope);
        }
        if (this.afterthoughtNode != null) {
            methodWriter.mark(begin);
            this.afterthoughtNode.write(classWriter, methodWriter, writeScope);
            methodWriter.writePop(MethodWriter.getType(this.afterthoughtNode.getExpressionType()).getSize());
        }
        if (this.afterthoughtNode != null || !allEscape) {
            methodWriter.goTo(start);
        }
        methodWriter.mark(end);
    }
}

