/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless.ir;

import io.lucenia.painless.ClassWriter;
import io.lucenia.painless.Location;
import io.lucenia.painless.MethodWriter;
import io.lucenia.painless.ir.BlockNode;
import io.lucenia.painless.ir.IRNode;
import io.lucenia.painless.phase.IRTreeVisitor;
import io.lucenia.painless.symbol.WriteScope;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class FunctionNode
extends IRNode {
    private BlockNode blockNode;
    protected String name;
    Class<?> returnType;
    List<Class<?>> typeParameters = new ArrayList();
    List<String> parameterNames = new ArrayList<String>();
    protected boolean isStatic;
    protected boolean hasVarArgs;
    protected boolean isSynthetic;
    protected int maxLoopCounter;

    public void setBlockNode(BlockNode blockNode) {
        this.blockNode = blockNode;
    }

    public BlockNode getBlockNode() {
        return this.blockNode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void addTypeParameter(Class<?> typeParameter) {
        this.typeParameters.add(typeParameter);
    }

    public List<Class<?>> getTypeParameters() {
        return this.typeParameters;
    }

    public void addParameterName(String parameterName) {
        this.parameterNames.add(parameterName);
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setVarArgs(boolean hasVarArgs) {
        this.hasVarArgs = hasVarArgs;
    }

    public boolean hasVarArgs() {
        return this.hasVarArgs;
    }

    public void setSynthetic(boolean isSythetic) {
        this.isSynthetic = isSythetic;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public void setMaxLoopCounter(int maxLoopCounter) {
        this.maxLoopCounter = maxLoopCounter;
    }

    public int getMaxLoopCounter() {
        return this.maxLoopCounter;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitFunction(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        this.getBlockNode().visit(irTreeVisitor, scope);
    }

    public FunctionNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        int access = 1;
        if (this.isStatic) {
            access |= 8;
        } else {
            writeScope.defineInternalVariable(Object.class, "this");
        }
        if (this.hasVarArgs) {
            access |= 0x80;
        }
        if (this.isSynthetic) {
            access |= 0x1000;
        }
        Type asmReturnType = MethodWriter.getType(this.returnType);
        Type[] asmParameterTypes = new Type[this.typeParameters.size()];
        for (int index = 0; index < asmParameterTypes.length; ++index) {
            Class<?> type = this.typeParameters.get(index);
            String name = this.parameterNames.get(index);
            writeScope.defineVariable(type, name);
            asmParameterTypes[index] = MethodWriter.getType(this.typeParameters.get(index));
        }
        Method method = new Method(this.name, asmReturnType, asmParameterTypes);
        methodWriter = classWriter.newMethodWriter(access, method);
        methodWriter.visitCode();
        if (this.maxLoopCounter > 0) {
            WriteScope.Variable loop = writeScope.defineInternalVariable(Integer.TYPE, "loop");
            methodWriter.push(this.maxLoopCounter);
            methodWriter.visitVarInsn(54, loop.getSlot());
        }
        this.blockNode.write(classWriter, methodWriter, writeScope.newScope());
        methodWriter.endMethod();
    }
}

