/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless.ir;

import io.lucenia.painless.ClassWriter;
import io.lucenia.painless.Location;
import io.lucenia.painless.MethodWriter;
import io.lucenia.painless.ir.UnaryNode;
import io.lucenia.painless.lookup.PainlessLookupUtility;
import io.lucenia.painless.lookup.def;
import io.lucenia.painless.phase.IRTreeVisitor;
import io.lucenia.painless.symbol.WriteScope;

public class InstanceofNode
extends UnaryNode {
    private Class<?> instanceType;

    public void setInstanceType(Class<?> instanceType) {
        this.instanceType = instanceType;
    }

    public Class<?> getInstanceType() {
        return this.instanceType;
    }

    public String getInstanceCanonicalTypeName() {
        return PainlessLookupUtility.typeToCanonicalTypeName(this.instanceType);
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitInstanceof(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        this.getChildNode().visit(irTreeVisitor, scope);
    }

    public InstanceofNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        this.getChildNode().write(classWriter, methodWriter, writeScope);
        if (this.instanceType == def.class) {
            methodWriter.writePop(MethodWriter.getType(this.getExpressionType()).getSize());
            methodWriter.push(true);
        } else if (this.getChildNode().getExpressionType().isPrimitive()) {
            methodWriter.writePop(MethodWriter.getType(this.getExpressionType()).getSize());
            methodWriter.push(PainlessLookupUtility.typeToBoxedType(this.instanceType).isAssignableFrom(PainlessLookupUtility.typeToBoxedType(this.getChildNode().getExpressionType())));
        } else {
            methodWriter.instanceOf(MethodWriter.getType(PainlessLookupUtility.typeToBoxedType(this.instanceType)));
        }
    }
}

