/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless.node;

import io.lucenia.painless.Location;
import io.lucenia.painless.node.AExpression;
import io.lucenia.painless.phase.UserTreeVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ECallLocal
extends AExpression {
    private final String methodName;
    private final List<AExpression> argumentNodes;

    public ECallLocal(int identifier, Location location, String methodName, List<AExpression> argumentNodes) {
        super(identifier, location);
        this.methodName = Objects.requireNonNull(methodName);
        this.argumentNodes = Collections.unmodifiableList(Objects.requireNonNull(argumentNodes));
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<AExpression> getArgumentNodes() {
        return this.argumentNodes;
    }

    @Override
    public <Scope> void visit(UserTreeVisitor<Scope> userTreeVisitor, Scope scope) {
        userTreeVisitor.visitCallLocal(this, scope);
    }

    @Override
    public <Scope> void visitChildren(UserTreeVisitor<Scope> userTreeVisitor, Scope scope) {
        for (AExpression argumentNode : this.argumentNodes) {
            argumentNode.visit(userTreeVisitor, scope);
        }
    }
}

