/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.license;

import io.lucenia.license.LuceniaLicense;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import org.apache.commons.codec.binary.Base16;

public class LicenseGen {
    static final String ALGORITHM = "SHA256withRSA";
    private final LuceniaLicense license;
    private final Base16 base16;

    public LicenseGen(LuceniaLicense license) {
        this.license = license;
        this.base16 = new Base16();
    }

    private String sign(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        String strippedKey = privateKey.replaceAll("\n", "").replaceAll("-----BEGIN PRIVATE KEY-----", "").replaceAll("-----END PRIVATE KEY-----", "");
        byte[] keyBytes = Base64.getDecoder().decode(strippedKey);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        Signature instance = Signature.getInstance(ALGORITHM);
        instance.initSign(factory.generatePrivate(spec));
        instance.update(this.license.text().getBytes(StandardCharsets.UTF_8));
        return this.base16.encodeAsString(instance.sign());
    }

    public String certificate(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        String text = this.license.text();
        String signature = this.sign(privateKey);
        return "--------BEGIN LICENSE CERTIFICATE-------\n" + text + "\n\n" + this.license.block(signature) + "\n--------END LICENSE CERTIFICATE---------\n";
    }
}

