/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.license;

import io.lucenia.license.ILuceniaLicense;
import io.lucenia.license.LuceniaDeveloperLicense;
import io.lucenia.license.LuceniaEnterpriseLicense;
import io.lucenia.license.LuceniaLicense;
import io.lucenia.license.LuceniaLocalLicense;
import io.lucenia.license.LuceniaProductLicense;
import io.lucenia.license.LuceniaTrialLicense;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LuceniaLicenseFactory {
    public static final String TRIAL_TYPE = "Trial License";
    public static final String DEVELOPER_TYPE = "Developer";
    public static final String LOCAL_TYPE = "Local";
    public static final String ENTERPRISE_TYPE = "Enterprise";
    public static final String PRODUCT_TYPE = "Product";
    private static final Logger logger = LogManager.getLogger(LuceniaLicenseFactory.class);

    public static ILuceniaLicense parse(String certificate) throws ParseException {
        String[] parts = LuceniaLicense.parts(certificate);
        String[] lines = (String[])Arrays.stream(parts[0].split("\n")).map(String::trim).toArray(String[]::new);
        UUID id = UUID.fromString(lines[0].split(": ")[1]);
        String type = lines[1].split(": ")[1];
        String licensee = lines[2].split(": ")[1];
        Date expiration = null;
        try {
            expiration = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT).parse(lines[3].split(": ")[1]);
        }
        catch (ParseException e) {
            throw new ParseException("Invalid expiration date", 0);
        }
        int resources = 1;
        if (lines.length > 4) {
            resources = Integer.parseInt(lines[4].split(": ")[1]);
        }
        return switch (type) {
            case TRIAL_TYPE -> {
                logger.info("Loading trial license");
                yield new LuceniaTrialLicense(id, licensee, expiration);
            }
            case DEVELOPER_TYPE -> {
                logger.info("Loading developer license");
                yield new LuceniaDeveloperLicense(id, licensee, expiration);
            }
            case LOCAL_TYPE -> {
                logger.info("Loading local license");
                yield new LuceniaLocalLicense(id, licensee, expiration, resources);
            }
            case ENTERPRISE_TYPE -> {
                logger.info("Loading enterprise license");
                yield new LuceniaEnterpriseLicense(id, licensee, expiration, resources);
            }
            case PRODUCT_TYPE -> {
                logger.info("Loading product license");
                yield new LuceniaProductLicense(id, licensee, expiration, resources);
            }
            default -> throw new IllegalArgumentException("Invalid license type:" + type + " Please check that you have pasted your certificate correctly.");
        };
    }
}

