/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.license;

import io.lucenia.license.task.LuceniaLicenseCheckerTaskParams;
import io.lucenia.license.task.LuceniaLicenseExecutor;
import io.lucenia.plugins.ClusterPlugin;
import io.lucenia.plugins.PersistentTaskPlugin;
import io.lucenia.plugins.Plugin;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.env.Environment;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.script.ScriptService;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsModule;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.opensearch.persistent.PersistentTaskParams;
import org.opensearch.persistent.PersistentTasksExecutor;
import org.opensearch.watcher.ResourceWatcherService;

public class LuceniaLicensePlugin
extends Plugin
implements PersistentTaskPlugin,
ClusterPlugin {
    public static final Setting<?> LICENSE_CERTIFICATE = Setting.simpleString((String)"plugins.license.certificate", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<?> LICENSE_CERTIFICATE_FILEPATH = Setting.simpleString((String)"plugins.license.certificate_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    LuceniaLicenseExecutor licenseExecutor;
    ClusterService clusterService;
    public static final int DEFAULT_MAX_CONN_PER_ROUTE = 10;
    public static final int DEFAULT_MAX_CONN_TOTAL = 30;

    public List<Setting<?>> getSettings() {
        return List.of(LICENSE_CERTIFICATE, LICENSE_CERTIFICATE_FILEPATH);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        CloseableHttpAsyncClient httpClient = AccessController.doPrivileged(this::createHttpClient);
        this.licenseExecutor = new LuceniaLicenseExecutor("lucenia-license-checker", client, httpClient, clusterService, 3600, threadPool);
        return Collections.singletonList(this.licenseExecutor);
    }

    CloseableHttpAsyncClient createHttpClient() {
        try {
            TlsStrategy tlsStrategy = ClientTlsStrategyBuilder.create().setSslContext(SSLContext.getDefault()).setTlsDetailsFactory(sslEngine -> new TlsDetails(sslEngine.getSession(), sslEngine.getApplicationProtocol())).build();
            PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setMaxConnPerRoute(10).setMaxConnTotal(30).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.LAX).setTlsStrategy(tlsStrategy).build();
            HttpAsyncClientBuilder finalBuilder = HttpAsyncClientBuilder.create().setDefaultRequestConfig(RequestConfig.DEFAULT).setConnectionManager((AsyncClientConnectionManager)connectionManager).setTargetAuthenticationStrategy((AuthenticationStrategy)DefaultAuthenticationStrategy.INSTANCE).disableAutomaticRetries();
            return AccessController.doPrivileged(() -> ((HttpAsyncClientBuilder)finalBuilder).build());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("could not create the default ssl context", e);
        }
    }

    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule, IndexNameExpressionResolver expressionResolver) {
        Settings settings = settingsModule.getSettings();
        String licenseCertificate = settings.get(LICENSE_CERTIFICATE.getKey(), "");
        String licenseCertificatePath = settings.get(LICENSE_CERTIFICATE_FILEPATH.getKey(), "");
        if (licenseCertificatePath.isBlank() && licenseCertificate.isBlank()) {
            throw new RuntimeException("Error initializing Lucenia License Checker. Please confirm plugins.license.certificate or plugins.license.certificate_filepath in your configuration is properly set in lucenia.yml.");
        }
        if (!licenseCertificate.isBlank()) {
            this.licenseExecutor.init(licenseCertificate);
        } else {
            try {
                Path path = Path.of(licenseCertificatePath, new String[0]);
                this.licenseExecutor.init(path);
            }
            catch (Exception e) {
                throw new RuntimeException("Error initializing Lucenia License Checker. Please confirm plugins.license.certificate_filepath in your configuration is properly set in lucenia.yml.", e);
            }
        }
        this.clusterService = clusterService;
        return List.of(this.licenseExecutor);
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "lucenia-license-checker", LuceniaLicenseCheckerTaskParams::new));
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return Collections.singletonList(new NamedXContentRegistry.Entry(PersistentTaskParams.class, LuceniaLicenseExecutor.LICENSE_CHECKER_PARSE_FIELD, (p, c) -> LuceniaLicensePlugin.fromXContent(p)));
    }

    public static LuceniaLicenseCheckerTaskParams fromXContent(XContentParser parser) {
        return (LuceniaLicenseCheckerTaskParams)LuceniaLicenseCheckerTaskParams.PARSER.apply(parser, null);
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(LICENSE_CERTIFICATE, LICENSE_CERTIFICATE_FILEPATH);
        }
    }
}

