/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.license.task;

import io.lucenia.license.task.LuceniaLicenseChecker;
import io.lucenia.license.task.LuceniaLicenseCheckerTaskParams;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.ParseField;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.block.ClusterBlocks;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.threadpool.ThreadPool;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.persistent.AllocatedPersistentTask;
import org.opensearch.persistent.PersistentTaskParams;
import org.opensearch.persistent.PersistentTaskState;
import org.opensearch.persistent.PersistentTasksCustomMetadata;
import org.opensearch.persistent.PersistentTasksExecutor;
import org.opensearch.persistent.PersistentTasksService;

public class LuceniaLicenseExecutor
extends PersistentTasksExecutor<PersistentTaskParams>
implements ClusterStateListener {
    private static final String TASK_DESCRIPTION = "Lucenia License Checker";
    private final ThreadPool threadPool;
    private final int pollIntervalSeconds;
    private String licenseCertificate;
    private final ClusterService clusterService;
    private final PersistentTasksService persistentTasksService;
    private final CloseableHttpAsyncClient httpClient;
    private final AtomicBoolean licenseCheckerStarted = new AtomicBoolean(false);
    public static final String LICENSE_CHECKER = "lucenia-license-checker";
    public static final ParseField LICENSE_CHECKER_PARSE_FIELD = new ParseField("lucenia-license-checker", new String[0]);
    private static final Logger logger = LogManager.getLogger(LuceniaLicenseExecutor.class);

    public LuceniaLicenseExecutor(String taskName, Client client, CloseableHttpAsyncClient httpClient, ClusterService clusterService, int pollIntervalSeconds, ThreadPool threadPool) {
        super(taskName, "management");
        this.threadPool = threadPool;
        this.pollIntervalSeconds = pollIntervalSeconds;
        this.clusterService = clusterService;
        this.persistentTasksService = new PersistentTasksService(clusterService, threadPool, client);
        this.httpClient = httpClient;
        this.httpClient.start();
    }

    public void init(Path licenseCertificateFile) {
        try (BufferedReader br = AccessController.doPrivileged(() -> {
            try {
                return Files.newBufferedReader(licenseCertificateFile, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line.trim());
                sb.append("\n");
            }
            this.licenseCertificate = sb.toString().trim();
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading license certificate file at " + this.licenseCertificate, e);
        }
        this.clusterService.addListener((ClusterStateListener)this);
    }

    public void init(String licenseCertificate) {
        this.licenseCertificate = licenseCertificate;
        this.clusterService.addListener((ClusterStateListener)this);
    }

    protected LuceniaLicenseChecker createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<PersistentTaskParams> taskInProgress, Map<String, String> headers) {
        return new LuceniaLicenseChecker(id, type, action, TASK_DESCRIPTION, parentTaskId, this.getExecutor(), () -> TimeValue.timeValueSeconds((long)this.pollIntervalSeconds), this.threadPool, this.httpClient, Collections.emptyMap(), this.licenseCertificate, this.clusterService.state().getMetadata().clusterUUID());
    }

    protected void nodeOperation(AllocatedPersistentTask task, PersistentTaskParams params, PersistentTaskState state) {
        logger.info("Lucenia License Executor checking license");
        LuceniaLicenseChecker llc = (LuceniaLicenseChecker)task;
        llc.setClusterService(this.clusterService);
        try {
            if (!llc.checkLicense()) {
                logger.error("Stopping the cluster due to invalid license");
                this.clusterService.stop();
            }
            llc.startLicenseChecker();
        }
        catch (Exception e) {
            logger.error("Error checking license", (Throwable)e);
            this.clusterService.stop();
        }
    }

    private void setEnabled(boolean enabled) {
        if (!this.clusterService.state().nodes().isLocalNodeElectedClusterManager()) {
            return;
        }
        if (enabled) {
            this.startTask();
        } else {
            this.stopTask();
        }
    }

    private void setClusterState(ClusterState state) {
    }

    private void startTask() {
        this.persistentTasksService.sendStartRequest(LICENSE_CHECKER, LICENSE_CHECKER, (PersistentTaskParams)new LuceniaLicenseCheckerTaskParams(), (ActionListener)new ActionListener<PersistentTasksCustomMetadata.PersistentTask<PersistentTaskParams>>(this){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<PersistentTaskParams> task) {
                logger.info("Lucenia License Executor successfully started with task id: {}", (Object)task.getId());
            }

            public void onFailure(Exception e) {
                logger.error("Lucenia License Executor failed to start", (Throwable)e);
            }
        });
    }

    private void stopTask() {
        ActionListener listener = ActionListenerHelper.wrap(r -> logger.info("Lucenia License Executor stopped"), e -> logger.error("Lucenia License Executor failed to stop", (Throwable)e));
        this.persistentTasksService.sendRemoveRequest(LICENSE_CHECKER, ActionListenerHelper.wrap(arg_0 -> ((ActionListener)listener).onResponse(arg_0), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
    }

    public void clusterChanged(ClusterStateChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(ClusterBlocks.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        DiscoveryNode managerNode = event.state().nodes().getClusterManagerNode();
        if (managerNode == null || !managerNode.equals((Object)this.clusterService.state().nodes().getLocalNode())) {
            return;
        }
        if (!this.licenseCheckerStarted.getAndSet(true)) {
            this.setEnabled(true);
        }
    }
}

