/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.jobscheduler;

import io.lucenia.jobscheduler.JobSchedulerSettings;
import io.lucenia.jobscheduler.LegacyOpenDistroJobSchedulerSettings;
import io.lucenia.jobscheduler.ScheduledJobProvider;
import io.lucenia.jobscheduler.rest.action.RestGetJobDetailsAction;
import io.lucenia.jobscheduler.rest.action.RestGetLockAction;
import io.lucenia.jobscheduler.rest.action.RestReleaseLockAction;
import io.lucenia.jobscheduler.scheduler.JobScheduler;
import io.lucenia.jobscheduler.sweeper.JobSweeper;
import io.lucenia.jobscheduler.utils.JobDetailsService;
import io.lucenia.plugins.ActionPlugin;
import io.lucenia.plugins.ExtensiblePlugin;
import io.lucenia.plugins.Plugin;
import io.lucenia.plugins.SystemIndexPlugin;
import io.skylite.common.lifecycle.LifecycleListener;
import io.skylite.core.ParseField;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.env.Environment;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.index.shard.IndexingOperationListener;
import io.skylite.core.indices.SystemIndexDescriptor;
import io.skylite.core.jobs.LockService;
import io.skylite.core.jobs.schedule.Schedule;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.script.ScriptService;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.IndexScopedSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsFilter;
import io.skylite.core.threadpool.ExecutorBuilder;
import io.skylite.core.threadpool.FixedExecutorBuilder;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.jobs.ScheduledJobParser;
import io.skylite.jobs.ScheduledJobRunner;
import io.skylite.jobs.schedule.ScheduleParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.IndexModule;
import org.opensearch.rest.RestController;
import org.opensearch.watcher.ResourceWatcherService;

public class JobSchedulerPlugin
extends Plugin
implements ActionPlugin,
ExtensiblePlugin,
SystemIndexPlugin {
    public static final String OPEN_DISTRO_JOB_SCHEDULER_THREAD_POOL_NAME = "open_distro_job_scheduler";
    public static final String JS_BASE_URI = "/_plugins/_job_scheduler";
    private static final Logger log = LogManager.getLogger(JobSchedulerPlugin.class);
    private JobSweeper sweeper;
    private JobScheduler scheduler;
    private LockService lockService;
    private Map<String, ScheduledJobProvider> indexToJobProviders;
    private Set<String> indicesToListen = new HashSet<String>();
    private JobDetailsService jobDetailsService;

    public JobSchedulerPlugin() {
        this.indexToJobProviders = new HashMap<String, ScheduledJobProvider>();
    }

    public Set<String> getIndicesToListen() {
        return this.indicesToListen;
    }

    public Map<String, ScheduledJobProvider> getIndexToJobProviders() {
        return this.indexToJobProviders;
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return Collections.singletonList(new SystemIndexDescriptor(".opendistro-job-scheduler-lock", "Stores lock documents used for plugin job execution"));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.lockService = new LockService(client, clusterService);
        this.jobDetailsService = new JobDetailsService(client, clusterService, this.indicesToListen, this.indexToJobProviders);
        this.scheduler = new JobScheduler(threadPool, this.lockService);
        this.sweeper = this.initSweeper(environment.settings(), client, clusterService, threadPool, xContentRegistry, this.scheduler, this.lockService, this.jobDetailsService);
        clusterService.addListener((ClusterStateListener)this.sweeper);
        clusterService.addLifecycleListener((LifecycleListener)this.sweeper);
        return Collections.emptyList();
    }

    public List<Setting<?>> getSettings() {
        ArrayList settingList = new ArrayList();
        settingList.add(LegacyOpenDistroJobSchedulerSettings.SWEEP_PAGE_SIZE);
        settingList.add(LegacyOpenDistroJobSchedulerSettings.REQUEST_TIMEOUT);
        settingList.add(LegacyOpenDistroJobSchedulerSettings.SWEEP_BACKOFF_MILLIS);
        settingList.add(LegacyOpenDistroJobSchedulerSettings.SWEEP_BACKOFF_RETRY_COUNT);
        settingList.add(LegacyOpenDistroJobSchedulerSettings.SWEEP_PERIOD);
        settingList.add(LegacyOpenDistroJobSchedulerSettings.JITTER_LIMIT);
        settingList.add(JobSchedulerSettings.SWEEP_PAGE_SIZE);
        settingList.add(JobSchedulerSettings.REQUEST_TIMEOUT);
        settingList.add(JobSchedulerSettings.SWEEP_BACKOFF_MILLIS);
        settingList.add(JobSchedulerSettings.SWEEP_BACKOFF_RETRY_COUNT);
        settingList.add(JobSchedulerSettings.SWEEP_PERIOD);
        settingList.add(JobSchedulerSettings.JITTER_LIMIT);
        return settingList;
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        int processorCount = SkyliteExecutors.allocatedProcessors((Settings)settings);
        ArrayList executorBuilders = new ArrayList();
        executorBuilders.add((ExecutorBuilder<?>)new FixedExecutorBuilder(settings, OPEN_DISTRO_JOB_SCHEDULER_THREAD_POOL_NAME, processorCount, 200, "opendistro.jobscheduler.threadpool"));
        return executorBuilders;
    }

    public void onIndexModule(IndexModule indexModule) {
        if (indexModule.getIndex().getName().equals(".lucenia-job-scheduler-job-details")) {
            indexModule.addIndexOperationListener((IndexingOperationListener)this.jobDetailsService);
            log.info("JobDetailsService started listening to operations on index {}", (Object)".lucenia-job-scheduler-job-details");
        }
        if (this.indicesToListen.contains(indexModule.getIndex().getName())) {
            indexModule.addIndexOperationListener((IndexingOperationListener)this.sweeper);
            log.info("JobSweeper started listening to operations on index {}", (Object)indexModule.getIndex().getName());
        }
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        for (io.skylite.jobs.spi.JobSchedulerPlugin extension : loader.loadExtensions(io.skylite.jobs.spi.JobSchedulerPlugin.class)) {
            String jobType = extension.getJobType();
            String jobIndexName = extension.getJobIndex();
            ScheduledJobParser jobParser = extension.getJobParser();
            ScheduledJobRunner runner = extension.getJobRunner();
            if (this.indexToJobProviders.containsKey(jobIndexName)) continue;
            ScheduledJobProvider provider = new ScheduledJobProvider(jobType, jobIndexName, jobParser, runner);
            this.indexToJobProviders.put(jobIndexName, provider);
            this.indicesToListen.add(jobIndexName);
            log.info("Loaded scheduler extension: {}, index: {}", (Object)jobType, (Object)jobIndexName);
        }
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        ArrayList<NamedXContentRegistry.Entry> registryEntries = new ArrayList<NamedXContentRegistry.Entry>();
        NamedXContentRegistry.Entry scheduleEntry = new NamedXContentRegistry.Entry(Schedule.class, new ParseField("schedule", new String[0]), ScheduleParser::parse);
        registryEntries.add(scheduleEntry);
        return registryEntries;
    }

    private JobSweeper initSweeper(Settings settings, Client client, ClusterService clusterService, ThreadPool threadPool, NamedXContentRegistry registry, JobScheduler scheduler, LockService lockService, JobDetailsService jobDetailsService) {
        return new JobSweeper(settings, client, clusterService, threadPool, registry, this.indexToJobProviders, scheduler, lockService, jobDetailsService);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        RestGetJobDetailsAction restGetJobDetailsAction = new RestGetJobDetailsAction(this.jobDetailsService);
        RestGetLockAction restGetLockAction = new RestGetLockAction(this.lockService);
        RestReleaseLockAction restReleaseLockAction = new RestReleaseLockAction(this.lockService);
        return List.of(restGetJobDetailsAction, restGetLockAction, restReleaseLockAction);
    }
}

