/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.jobscheduler.transport.request;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.jobs.JobDocVersion;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;

public class JobParameterRequest
extends ActionRequest {
    private final String accessToken;
    private final BytesReference jobSource;
    private final String id;
    private final JobDocVersion jobDocVersion;

    public JobParameterRequest(String accessToken, XContentParser jobParser, String id, JobDocVersion jobDocVersion) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.copyCurrentStructure(jobParser);
        this.jobSource = BytesReference.bytes((XContentBuilder)builder);
        this.accessToken = accessToken;
        this.id = id;
        this.jobDocVersion = jobDocVersion;
    }

    public JobParameterRequest(StreamInput in) throws IOException {
        this.accessToken = in.readString();
        this.jobSource = in.readBytesReference();
        this.id = in.readString();
        this.jobDocVersion = new JobDocVersion(in);
    }

    public JobParameterRequest(byte[] requestParams) throws IOException {
        this(StreamInput.wrap((byte[])requestParams));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.accessToken);
        out.writeBytesReference(this.jobSource);
        out.writeString(this.id);
        this.jobDocVersion.writeTo(out);
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public BytesReference getJobSource() {
        return this.jobSource;
    }

    public String getId() {
        return this.id;
    }

    public JobDocVersion getJobDocVersion() {
        return this.jobDocVersion;
    }
}

