/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.common;

import io.skylite.common.Nullable;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;
import org.opensearch.knn.index.engine.qframe.QuantizationConfigParser;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.indices.ModelMetadata;
import org.opensearch.knn.indices.ModelUtil;

public final class FieldInfoExtractor {
    public static KNNEngine extractKNNEngine(FieldInfo field) {
        ModelMetadata modelMetadata = ModelUtil.getModelMetadata((String)field.attributes().get("model_id"));
        if (modelMetadata != null) {
            return modelMetadata.getKnnEngine();
        }
        String engineName = field.attributes().getOrDefault("engine", KNNEngine.DEFAULT.getName());
        return KNNEngine.getEngine(engineName);
    }

    public static VectorDataType extractVectorDataType(FieldInfo fieldInfo) {
        ModelMetadata modelMetadata;
        String vectorDataTypeString = fieldInfo.getAttribute("data_type");
        if (StringUtils.isEmpty((String)vectorDataTypeString) && (modelMetadata = ModelUtil.getModelMetadata(fieldInfo.getAttribute("model_id"))) != null) {
            VectorDataType vectorDataType = modelMetadata.getVectorDataType();
            vectorDataTypeString = vectorDataType == null ? null : vectorDataType.getValue();
        }
        return StringUtils.isNotEmpty((String)vectorDataTypeString) ? VectorDataType.get(vectorDataTypeString) : VectorDataType.DEFAULT;
    }

    public static QuantizationConfig extractQuantizationConfig(FieldInfo fieldInfo) {
        String quantizationConfigString = fieldInfo.getAttribute("qframe_config");
        if (StringUtils.isEmpty((String)quantizationConfigString)) {
            return QuantizationConfig.EMPTY;
        }
        return QuantizationConfigParser.fromCsv(quantizationConfigString);
    }

    public static SpaceType getSpaceType(ModelDao modelDao, FieldInfo fieldInfo) {
        String spaceTypeString = fieldInfo.getAttribute("spaceType");
        if (StringUtils.isNotEmpty((String)spaceTypeString)) {
            return SpaceType.getSpace(spaceTypeString);
        }
        String modelId = fieldInfo.getAttribute("model_id");
        if (StringUtils.isEmpty((String)modelId)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unable to find the Space Type from Field Info attribute for field %s", fieldInfo.getName()));
        }
        ModelMetadata modelMetadata = modelDao.getMetadata(modelId);
        if (modelMetadata == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unable to find the model metadata for model id %s", modelId));
        }
        return modelMetadata.getSpaceType();
    }

    @Nullable
    public static FieldInfo getFieldInfo(LeafReader leafReader, String fieldName) {
        return leafReader.getFieldInfos().fieldInfo(fieldName);
    }
}

