/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import io.skylite.common.Nullable;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.index.fielddata.IndexFieldDataCache;
import io.skylite.core.index.fielddata.IndexFieldDataFieldComparatorSource;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.sort.BucketedSort;
import io.skylite.core.search.sort.SortOrder;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.SortField;
import org.opensearch.knn.index.KNNVectorDVLeafFieldData;
import org.opensearch.knn.index.VectorDataType;

public class KNNVectorIndexFieldData
implements IndexFieldData<KNNVectorDVLeafFieldData> {
    private final String fieldName;
    private final ValuesSourceType valuesSourceType;
    private final VectorDataType vectorDataType;

    public KNNVectorIndexFieldData(String fieldName, ValuesSourceType valuesSourceType, VectorDataType vectorDataType) {
        this.fieldName = fieldName;
        this.valuesSourceType = valuesSourceType;
        this.vectorDataType = vectorDataType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    public KNNVectorDVLeafFieldData load(LeafReaderContext context) {
        return new KNNVectorDVLeafFieldData(context.reader(), this.fieldName, this.vectorDataType);
    }

    public KNNVectorDVLeafFieldData loadDirect(LeafReaderContext context) {
        return this.load(context);
    }

    public BaseIndexFieldData.Global<KNNVectorDVLeafFieldData> loadGlobal(DirectoryReader directoryReader) {
        throw new UnsupportedOperationException("Global loading is not supported for binary fields");
    }

    public BaseIndexFieldData.Global<KNNVectorDVLeafFieldData> loadGlobalDirect(DirectoryReader directoryReader) throws Exception {
        return this.loadGlobal(directoryReader);
    }

    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, boolean reverse) {
        throw new UnsupportedOperationException("knn vector field doesn't support this operation");
    }

    public BucketedSort newBucketedSort(BigArrays bigArrays, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new UnsupportedOperationException("knn vector field doesn't support this operation");
    }

    public static class Builder
    implements BaseIndexFieldData.Builder {
        private final String name;
        private final ValuesSourceType valuesSourceType;
        private final VectorDataType vectorDataType;

        public Builder(String name, ValuesSourceType valuesSourceType, VectorDataType vectorDataType) {
            this.name = name;
            this.valuesSourceType = valuesSourceType;
            this.vectorDataType = vectorDataType;
        }

        public IndexFieldData<?> build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new KNNVectorIndexFieldData(this.name, this.valuesSourceType, this.vectorDataType);
        }
    }
}

