/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.core.index.fielddata.ScriptDocValues;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.opensearch.knn.index.VectorDataType;

public abstract class KNNVectorScriptDocValues
extends ScriptDocValues<float[]> {
    protected final KnnVectorValues.DocIndexIterator vectorValues;
    private final String fieldName;
    private final VectorDataType vectorDataType;
    private boolean docExists = false;
    private int lastDocID = -1;

    private KNNVectorScriptDocValues(KnnVectorValues.DocIndexIterator vectorValues, String fieldName, VectorDataType vectorDataType) {
        this.vectorValues = vectorValues;
        this.fieldName = fieldName;
        this.vectorDataType = vectorDataType;
    }

    public void setNextDocId(int docId) throws IOException {
        if (docId < this.lastDocID) {
            throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs docID=" + docId);
        }
        this.lastDocID = docId;
        int curDocID = this.vectorValues.docID();
        if (this.lastDocID > curDocID) {
            curDocID = this.vectorValues.advance(docId);
        }
        this.docExists = this.lastDocID == curDocID;
    }

    public float[] getValue() {
        if (!this.docExists) {
            String errorMessage = String.format(Locale.ROOT, "One of the document doesn't have a value for field '%s'. This can be avoided by checking if a document has a value for the field or not by doc['%s'].size() == 0 ? 0 : {your script}", this.fieldName, this.fieldName);
            throw new IllegalStateException(errorMessage);
        }
        try {
            return this.doGetValue();
        }
        catch (IOException e) {
            throw SkyliteExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    protected abstract float[] doGetValue() throws IOException;

    public int size() {
        return this.docExists ? 1 : 0;
    }

    public float[] get(int i) {
        throw new UnsupportedOperationException("knn vector does not support this operation");
    }

    public static KNNVectorScriptDocValues create(Object values, String fieldName, VectorDataType vectorDataType) {
        Objects.requireNonNull(values, "values must not be null");
        if (values instanceof FloatVectorValues) {
            return new KNNFloatVectorScriptDocValues((FloatVectorValues)values, fieldName, vectorDataType);
        }
        if (values instanceof ByteVectorValues) {
            return new KNNByteVectorScriptDocValues((ByteVectorValues)values, fieldName, vectorDataType);
        }
        if (values instanceof BinaryDocValues) {
            return new KNNNativeVectorScriptDocValues((BinaryDocValues)values, fieldName, vectorDataType);
        }
        throw new IllegalArgumentException("Unsupported values type: " + String.valueOf(values.getClass()));
    }

    public static KNNVectorScriptDocValues createFromDISI(DocIdSetIterator values, String fieldName, VectorDataType vectorDataType) {
        if (values instanceof BinaryDocValues) {
            return new KNNNativeVectorScriptDocValues((BinaryDocValues)values, fieldName, vectorDataType);
        }
        throw new IllegalArgumentException("Unsupported values type: " + String.valueOf(values.getClass()));
    }

    public static KNNVectorScriptDocValues emptyValues(String fieldName, VectorDataType type) {
        return new KNNVectorScriptDocValues(KNNVectorScriptDocValues.empty(), fieldName, type){

            @Override
            protected float[] doGetValue() throws IOException {
                throw new UnsupportedOperationException("empty values");
            }
        };
    }

    private static KnnVectorValues.DocIndexIterator empty() {
        return new KnnVectorValues.DocIndexIterator(){
            boolean exhausted = false;

            public int index() {
                return this.docID();
            }

            public int advance(int target) {
                assert (!this.exhausted);
                assert (target >= 0);
                this.exhausted = true;
                return Integer.MAX_VALUE;
            }

            public int docID() {
                return this.exhausted ? Integer.MAX_VALUE : -1;
            }

            public int nextDoc() {
                assert (!this.exhausted);
                this.exhausted = true;
                return Integer.MAX_VALUE;
            }

            public long cost() {
                return 0L;
            }
        };
    }

    public VectorDataType getVectorDataType() {
        return this.vectorDataType;
    }

    private static final class KNNFloatVectorScriptDocValues
    extends KNNVectorScriptDocValues {
        private final FloatVectorValues values;
        private final KnnVectorValues.DocIndexIterator iterator;

        KNNFloatVectorScriptDocValues(FloatVectorValues values, String field, VectorDataType type) {
            super(values.iterator(), field, type);
            this.values = values;
            this.iterator = this.vectorValues instanceof KnnVectorValues.DocIndexIterator ? this.vectorValues : values.iterator();
        }

        @Override
        protected float[] doGetValue() throws IOException {
            int ord = this.iterator.index();
            if (ord == Integer.MAX_VALUE) {
                throw new IllegalStateException("No more ordinals to retrieve vector values.");
            }
            return this.values.vectorValue(ord);
        }
    }

    private static final class KNNByteVectorScriptDocValues
    extends KNNVectorScriptDocValues {
        private final ByteVectorValues values;
        private final KnnVectorValues.DocIndexIterator iterator;

        KNNByteVectorScriptDocValues(ByteVectorValues values, String field, VectorDataType type) {
            super(values.iterator(), field, type);
            this.values = values;
            this.iterator = this.vectorValues instanceof KnnVectorValues.DocIndexIterator ? this.vectorValues : values.iterator();
        }

        @Override
        protected float[] doGetValue() throws IOException {
            int docId = this.iterator.index();
            if (docId == Integer.MAX_VALUE) {
                throw new IllegalStateException("No more ordinals to retrieve vector values");
            }
            byte[] bytes = this.values.vectorValue(docId);
            float[] value = new float[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                value[i] = bytes[i];
            }
            return value;
        }
    }

    private static final class KNNNativeVectorScriptDocValues
    extends KNNVectorScriptDocValues {
        private final BinaryDocValues values;

        KNNNativeVectorScriptDocValues(BinaryDocValues values, String field, VectorDataType type) {
            super(KNNNativeVectorScriptDocValues.asDocIndexIterator(values), field, type);
            this.values = values;
        }

        @Override
        protected float[] doGetValue() throws IOException {
            return this.getVectorDataType().getVectorFromBytesRef(this.values.binaryValue());
        }

        public static KnnVectorValues.DocIndexIterator asDocIndexIterator(final BinaryDocValues values) {
            return new KnnVectorValues.DocIndexIterator(){
                int ord = -1;

                public int docID() {
                    return values.docID();
                }

                public int index() {
                    return this.ord;
                }

                public int nextDoc() throws IOException {
                    if (this.docID() == Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    ++this.ord;
                    return values.nextDoc();
                }

                public int advance(int target) throws IOException {
                    return values.advance(target);
                }

                public long cost() {
                    return values.cost();
                }
            };
        }
    }
}

