/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN1010Codec;

import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CompoundFormat;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.opensearch.knn.index.codec.KNNCodecVersion;
import org.opensearch.knn.index.codec.KNNFormatFacade;

public class KNN1010Codec
extends FilterCodec {
    private static final KNNCodecVersion VERSION = KNNCodecVersion.V_10_1_0;
    private final KNNFormatFacade knnFormatFacade;
    private final PerFieldKnnVectorsFormat perFieldKnnVectorsFormat;

    public KNN1010Codec() {
        this(VERSION.getDefaultCodecDelegate(), VERSION.getPerFieldKnnVectorsFormat());
    }

    protected KNN1010Codec(Codec delegate, PerFieldKnnVectorsFormat knnVectorsFormat) {
        super(VERSION.getCodecName(), delegate);
        this.knnFormatFacade = VERSION.getKnnFormatFacadeSupplier().apply(delegate);
        this.perFieldKnnVectorsFormat = knnVectorsFormat;
    }

    public DocValuesFormat docValuesFormat() {
        return this.knnFormatFacade.docValuesFormat();
    }

    public CompoundFormat compoundFormat() {
        return this.knnFormatFacade.compoundFormat();
    }

    public KnnVectorsFormat knnVectorsFormat() {
        return this.perFieldKnnVectorsFormat;
    }

    public static KNN1010CodecBuilder builder() {
        return new KNN1010CodecBuilder();
    }

    public static class KNN1010CodecBuilder {
        private Codec delegate;
        private PerFieldKnnVectorsFormat knnVectorsFormat;

        KNN1010CodecBuilder() {
        }

        public KNN1010CodecBuilder delegate(Codec delegate) {
            this.delegate = delegate;
            return this;
        }

        public KNN1010CodecBuilder knnVectorsFormat(PerFieldKnnVectorsFormat knnVectorsFormat) {
            this.knnVectorsFormat = knnVectorsFormat;
            return this;
        }

        public KNN1010Codec build() {
            return new KNN1010Codec(this.delegate, this.knnVectorsFormat);
        }

        public String toString() {
            return "KNN1010Codec.KNN1010CodecBuilder(delegate=" + String.valueOf(this.delegate) + ", knnVectorsFormat=" + String.valueOf(this.knnVectorsFormat) + ")";
        }
    }
}

