/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN80Codec;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocIDMerger;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.codec.util.BinaryDocValuesSub;

public class KNN80BinaryDocValues
extends BinaryDocValues {
    private DocIDMerger<BinaryDocValuesSub> docIDMerger;
    private long totalLiveDocs;
    private BinaryDocValuesSub current;
    private int docID = -1;

    KNN80BinaryDocValues(DocIDMerger<BinaryDocValuesSub> docIdMerger) {
        this.docIDMerger = docIdMerger;
    }

    public int docID() {
        return this.docID;
    }

    public int nextDoc() throws IOException {
        this.current = (BinaryDocValuesSub)this.docIDMerger.next();
        this.docID = this.current == null ? Integer.MAX_VALUE : this.current.mappedDocID;
        return this.docID;
    }

    public int advance(int target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean advanceExact(int target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long cost() {
        throw new UnsupportedOperationException();
    }

    public BytesRef binaryValue() throws IOException {
        return this.current.getValues().binaryValue();
    }

    public KNN80BinaryDocValues setTotalLiveDocs(long totalLiveDocs) {
        this.totalLiveDocs = totalLiveDocs;
        return this;
    }

    public long getTotalLiveDocs() {
        return this.totalLiveDocs;
    }
}

