/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.nativeindex;

import java.io.IOException;
import org.opensearch.knn.index.codec.nativeindex.IndexBuildSetup;
import org.opensearch.knn.index.codec.nativeindex.model.BuildIndexParams;
import org.opensearch.knn.index.quantizationservice.QuantizationService;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.quantization.models.quantizationOutput.QuantizationOutput;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationState;

final class QuantizationIndexUtils {
    QuantizationIndexUtils() {
    }

    static Object processAndReturnVector(KNNVectorValues<?> knnVectorValues, IndexBuildSetup indexBuildSetup) throws IOException {
        QuantizationService quantizationService = QuantizationService.getInstance();
        if (indexBuildSetup.getQuantizationState() != null && indexBuildSetup.getQuantizationOutput() != null) {
            quantizationService.quantize(indexBuildSetup.getQuantizationState(), knnVectorValues.getVector(), indexBuildSetup.getQuantizationOutput());
            return indexBuildSetup.getQuantizationOutput().getQuantizedVectorCopy();
        }
        return knnVectorValues.conditionalCloneVector();
    }

    static IndexBuildSetup prepareIndexBuild(KNNVectorValues<?> knnVectorValues, BuildIndexParams indexInfo) {
        int dimensions;
        int bytesPerVector;
        QuantizationState quantizationState = indexInfo.getQuantizationState();
        QuantizationOutput quantizationOutput = null;
        QuantizationService quantizationService = QuantizationService.getInstance();
        if (quantizationState != null) {
            bytesPerVector = quantizationState.getBytesPerVector();
            dimensions = quantizationState.getDimensions();
            quantizationOutput = quantizationService.createQuantizationOutput(quantizationState.getQuantizationParams());
        } else {
            bytesPerVector = knnVectorValues.bytesPerVector();
            dimensions = knnVectorValues.dimension();
        }
        return new IndexBuildSetup(bytesPerVector, dimensions, quantizationOutput, quantizationState);
    }
}

