/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.nativeindex.model;

import io.skylite.common.Nullable;
import java.util.Map;
import java.util.Objects;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.store.IndexOutputWithBuffer;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationState;

public final class BuildIndexParams {
    private final String fieldName;
    private final KNNEngine knnEngine;
    private final IndexOutputWithBuffer indexOutputWithBuffer;
    private final VectorDataType vectorDataType;
    private final Map<String, Object> parameters;
    @Nullable
    private final QuantizationState quantizationState;
    private final KNNVectorValues<?> vectorValues;
    private final int totalLiveDocs;

    BuildIndexParams(String fieldName, KNNEngine knnEngine, IndexOutputWithBuffer indexOutputWithBuffer, VectorDataType vectorDataType, Map<String, Object> parameters, QuantizationState quantizationState, KNNVectorValues<?> vectorValues, int totalLiveDocs) {
        this.fieldName = fieldName;
        this.knnEngine = knnEngine;
        this.indexOutputWithBuffer = indexOutputWithBuffer;
        this.vectorDataType = vectorDataType;
        this.parameters = parameters;
        this.quantizationState = quantizationState;
        this.vectorValues = vectorValues;
        this.totalLiveDocs = totalLiveDocs;
    }

    public static BuildIndexParamsBuilder builder() {
        return new BuildIndexParamsBuilder();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public KNNEngine getKnnEngine() {
        return this.knnEngine;
    }

    public IndexOutputWithBuffer getIndexOutputWithBuffer() {
        return this.indexOutputWithBuffer;
    }

    public VectorDataType getVectorDataType() {
        return this.vectorDataType;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public QuantizationState getQuantizationState() {
        return this.quantizationState;
    }

    public KNNVectorValues<?> getVectorValues() {
        return this.vectorValues;
    }

    public int getTotalLiveDocs() {
        return this.totalLiveDocs;
    }

    public boolean equals(Object o) {
        QuantizationState other_quantizationState;
        Map<String, Object> other_parameters;
        VectorDataType other_vectorDataType;
        IndexOutputWithBuffer other_indexOutputWithBuffer;
        KNNEngine other_knnEngine;
        String other_fieldName;
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildIndexParams)) {
            return false;
        }
        BuildIndexParams other = (BuildIndexParams)o;
        if (this.getTotalLiveDocs() != other.getTotalLiveDocs()) {
            return false;
        }
        String this_fieldName = this.getFieldName();
        if (!Objects.equals(this_fieldName, other_fieldName = other.getFieldName())) {
            return false;
        }
        KNNEngine this_knnEngine = this.getKnnEngine();
        if (!Objects.equals(this_knnEngine, other_knnEngine = other.getKnnEngine())) {
            return false;
        }
        IndexOutputWithBuffer this_indexOutputWithBuffer = this.getIndexOutputWithBuffer();
        if (!Objects.equals(this_indexOutputWithBuffer, other_indexOutputWithBuffer = other.getIndexOutputWithBuffer())) {
            return false;
        }
        VectorDataType this_vectorDataType = this.getVectorDataType();
        if (!Objects.equals((Object)this_vectorDataType, (Object)(other_vectorDataType = other.getVectorDataType()))) {
            return false;
        }
        Map<String, Object> this_parameters = this.getParameters();
        if (!Objects.equals(this_parameters, other_parameters = other.getParameters())) {
            return false;
        }
        QuantizationState this_quantizationState = this.getQuantizationState();
        if (!Objects.equals(this_quantizationState, other_quantizationState = other.getQuantizationState())) {
            return false;
        }
        KNNVectorValues<?> this_vectorValues = this.getVectorValues();
        KNNVectorValues<?> other_vectorValues = other.getVectorValues();
        return Objects.equals(this_vectorValues, other_vectorValues);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalLiveDocs();
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        KNNEngine $knnEngine = this.getKnnEngine();
        result = result * 59 + ($knnEngine == null ? 43 : $knnEngine.hashCode());
        IndexOutputWithBuffer $indexOutputWithBuffer = this.getIndexOutputWithBuffer();
        result = result * 59 + ($indexOutputWithBuffer == null ? 43 : $indexOutputWithBuffer.hashCode());
        VectorDataType $vectorDataType = this.getVectorDataType();
        result = result * 59 + ($vectorDataType == null ? 43 : ((Object)((Object)$vectorDataType)).hashCode());
        Map<String, Object> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        QuantizationState $quantizationState = this.getQuantizationState();
        result = result * 59 + ($quantizationState == null ? 43 : $quantizationState.hashCode());
        KNNVectorValues<?> $vectorValues = this.getVectorValues();
        result = result * 59 + ($vectorValues == null ? 43 : ((Object)$vectorValues).hashCode());
        return result;
    }

    public String toString() {
        return "BuildIndexParams(fieldName=" + this.getFieldName() + ", knnEngine=" + String.valueOf(this.getKnnEngine()) + ", indexOutputWithBuffer=" + String.valueOf(this.getIndexOutputWithBuffer()) + ", vectorDataType=" + String.valueOf((Object)this.getVectorDataType()) + ", parameters=" + String.valueOf(this.getParameters()) + ", quantizationState=" + String.valueOf(this.getQuantizationState()) + ", vectorValues=" + String.valueOf(this.getVectorValues()) + ", totalLiveDocs=" + this.getTotalLiveDocs() + ")";
    }

    public static class BuildIndexParamsBuilder {
        private String fieldName;
        private KNNEngine knnEngine;
        private IndexOutputWithBuffer indexOutputWithBuffer;
        private VectorDataType vectorDataType;
        private Map<String, Object> parameters;
        private QuantizationState quantizationState;
        private KNNVectorValues<?> vectorValues;
        private int totalLiveDocs;

        BuildIndexParamsBuilder() {
        }

        public BuildIndexParamsBuilder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public BuildIndexParamsBuilder knnEngine(KNNEngine knnEngine) {
            this.knnEngine = knnEngine;
            return this;
        }

        public BuildIndexParamsBuilder indexOutputWithBuffer(IndexOutputWithBuffer indexOutputWithBuffer) {
            this.indexOutputWithBuffer = indexOutputWithBuffer;
            return this;
        }

        public BuildIndexParamsBuilder vectorDataType(VectorDataType vectorDataType) {
            this.vectorDataType = vectorDataType;
            return this;
        }

        public BuildIndexParamsBuilder parameters(Map<String, Object> parameters) {
            this.parameters = parameters;
            return this;
        }

        public BuildIndexParamsBuilder quantizationState(QuantizationState quantizationState) {
            this.quantizationState = quantizationState;
            return this;
        }

        public BuildIndexParamsBuilder vectorValues(KNNVectorValues<?> vectorValues) {
            this.vectorValues = vectorValues;
            return this;
        }

        public BuildIndexParamsBuilder totalLiveDocs(int totalLiveDocs) {
            this.totalLiveDocs = totalLiveDocs;
            return this;
        }

        public BuildIndexParams build() {
            return new BuildIndexParams(this.fieldName, this.knnEngine, this.indexOutputWithBuffer, this.vectorDataType, this.parameters, this.quantizationState, this.vectorValues, this.totalLiveDocs);
        }

        public String toString() {
            return "BuildIndexParams.BuildIndexParamsBuilder(fieldName=" + this.fieldName + ", knnEngine=" + String.valueOf(this.knnEngine) + ", indexOutputWithBuffer=" + String.valueOf(this.indexOutputWithBuffer) + ", vectorDataType=" + String.valueOf((Object)this.vectorDataType) + ", parameters=" + String.valueOf(this.parameters) + ", quantizationState=" + String.valueOf(this.quantizationState) + ", vectorValues=" + String.valueOf(this.vectorValues) + ", totalLiveDocs=" + this.totalLiveDocs + ")";
        }
    }
}

