/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.params;

import java.util.Map;
import org.opensearch.knn.index.SpaceType;

public class KNNVectorsFormatParams {
    private int maxConnections;
    private int beamWidth;
    private final SpaceType spaceType;

    public KNNVectorsFormatParams(Map<String, Object> params, int defaultMaxConnections, int defaultBeamWidth) {
        this(params, defaultMaxConnections, defaultBeamWidth, SpaceType.UNDEFINED);
    }

    public KNNVectorsFormatParams(Map<String, Object> params, int defaultMaxConnections, int defaultBeamWidth, SpaceType spaceType) {
        this.initMaxConnections(params, defaultMaxConnections);
        this.initBeamWidth(params, defaultBeamWidth);
        this.spaceType = spaceType;
    }

    public boolean validate(Map<String, Object> params) {
        return true;
    }

    private void initMaxConnections(Map<String, Object> params, int defaultMaxConnections) {
        if (params != null && params.containsKey("m")) {
            this.maxConnections = (Integer)params.get("m");
            return;
        }
        this.maxConnections = defaultMaxConnections;
    }

    private void initBeamWidth(Map<String, Object> params, int defaultBeamWidth) {
        if (params != null && params.containsKey("ef_construction")) {
            this.beamWidth = (Integer)params.get("ef_construction");
            return;
        }
        this.beamWidth = defaultBeamWidth;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getBeamWidth() {
        return this.beamWidth;
    }

    public SpaceType getSpaceType() {
        return this.spaceType;
    }
}

