/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine;

import java.util.Collections;
import java.util.Map;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;
import org.opensearch.knn.index.mapper.PerDimensionProcessor;
import org.opensearch.knn.index.mapper.PerDimensionValidator;
import org.opensearch.knn.index.mapper.VectorValidator;

public class KNNLibraryIndexingContextImpl
implements KNNLibraryIndexingContext {
    private VectorValidator vectorValidator;
    private PerDimensionValidator perDimensionValidator;
    private PerDimensionProcessor perDimensionProcessor;
    private Map<String, Object> parameters;
    private QuantizationConfig quantizationConfig;

    KNNLibraryIndexingContextImpl(VectorValidator vectorValidator, PerDimensionValidator perDimensionValidator, PerDimensionProcessor perDimensionProcessor, Map<String, Object> parameters, QuantizationConfig quantizationConfig) {
        this.vectorValidator = vectorValidator;
        this.perDimensionValidator = perDimensionValidator;
        this.perDimensionProcessor = perDimensionProcessor;
        this.parameters = parameters;
        this.quantizationConfig = quantizationConfig;
    }

    @Override
    public Map<String, Object> getLibraryParameters() {
        return this.parameters;
    }

    @Override
    public QuantizationConfig getQuantizationConfig() {
        return this.quantizationConfig;
    }

    @Override
    public VectorValidator getVectorValidator() {
        return this.vectorValidator;
    }

    @Override
    public PerDimensionValidator getPerDimensionValidator() {
        return this.perDimensionValidator;
    }

    @Override
    public PerDimensionProcessor getPerDimensionProcessor() {
        return this.perDimensionProcessor;
    }

    private static Map<String, Object> $default$parameters() {
        return Collections.emptyMap();
    }

    private static QuantizationConfig $default$quantizationConfig() {
        return QuantizationConfig.EMPTY;
    }

    public static KNNLibraryIndexingContextImplBuilder builder() {
        return new KNNLibraryIndexingContextImplBuilder();
    }

    public static class KNNLibraryIndexingContextImplBuilder {
        private VectorValidator vectorValidator;
        private PerDimensionValidator perDimensionValidator;
        private PerDimensionProcessor perDimensionProcessor;
        private boolean parameters$set;
        private Map<String, Object> parameters$value;
        private boolean quantizationConfig$set;
        private QuantizationConfig quantizationConfig$value;

        KNNLibraryIndexingContextImplBuilder() {
        }

        public KNNLibraryIndexingContextImplBuilder vectorValidator(VectorValidator vectorValidator) {
            this.vectorValidator = vectorValidator;
            return this;
        }

        public KNNLibraryIndexingContextImplBuilder perDimensionValidator(PerDimensionValidator perDimensionValidator) {
            this.perDimensionValidator = perDimensionValidator;
            return this;
        }

        public KNNLibraryIndexingContextImplBuilder perDimensionProcessor(PerDimensionProcessor perDimensionProcessor) {
            this.perDimensionProcessor = perDimensionProcessor;
            return this;
        }

        public KNNLibraryIndexingContextImplBuilder parameters(Map<String, Object> parameters) {
            this.parameters$value = parameters;
            this.parameters$set = true;
            return this;
        }

        public KNNLibraryIndexingContextImplBuilder quantizationConfig(QuantizationConfig quantizationConfig) {
            this.quantizationConfig$value = quantizationConfig;
            this.quantizationConfig$set = true;
            return this;
        }

        public KNNLibraryIndexingContextImpl build() {
            Map<String, Object> parameters$value = this.parameters$value;
            if (!this.parameters$set) {
                parameters$value = KNNLibraryIndexingContextImpl.$default$parameters();
            }
            QuantizationConfig quantizationConfig$value = this.quantizationConfig$value;
            if (!this.quantizationConfig$set) {
                quantizationConfig$value = KNNLibraryIndexingContextImpl.$default$quantizationConfig();
            }
            return new KNNLibraryIndexingContextImpl(this.vectorValidator, this.perDimensionValidator, this.perDimensionProcessor, parameters$value, quantizationConfig$value);
        }

        public String toString() {
            return "KNNLibraryIndexingContextImpl.KNNLibraryIndexingContextImplBuilder(vectorValidator=" + String.valueOf(this.vectorValidator) + ", perDimensionValidator=" + String.valueOf(this.perDimensionValidator) + ", perDimensionProcessor=" + String.valueOf(this.perDimensionProcessor) + ", parameters$value=" + String.valueOf(this.parameters$value) + ", quantizationConfig$value=" + String.valueOf(this.quantizationConfig$value) + ")";
        }
    }
}

