/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine;

import io.skylite.Version;
import io.skylite.core.settings.Settings;
import java.util.Objects;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.Mode;

public final class KNNMethodConfigContext {
    private VectorDataType vectorDataType;
    private Integer dimension;
    private Settings indexSettings;
    private Version<?> versionCreated;
    private Mode mode;
    private CompressionLevel compressionLevel;
    public static final KNNMethodConfigContext EMPTY = KNNMethodConfigContext.builder().build();

    public KNNMethodConfigContext(VectorDataType vectorDataType, Integer dimension, Settings indexSettings, Version<?> versionCreated, Mode mode, CompressionLevel compressionLevel) {
        this.vectorDataType = vectorDataType;
        this.dimension = dimension;
        this.indexSettings = indexSettings;
        this.versionCreated = versionCreated;
        this.mode = mode;
        this.compressionLevel = compressionLevel;
    }

    private static Mode $default$mode() {
        return Mode.NOT_CONFIGURED;
    }

    private static CompressionLevel $default$compressionLevel() {
        return CompressionLevel.NOT_CONFIGURED;
    }

    public static KNNMethodConfigContextBuilder builder() {
        return new KNNMethodConfigContextBuilder();
    }

    public void setVectorDataType(VectorDataType vectorDataType) {
        this.vectorDataType = vectorDataType;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public void setIndexSettings(Settings indexSettings) {
        this.indexSettings = indexSettings;
    }

    public void setVersionCreated(Version<?> versionCreated) {
        this.versionCreated = versionCreated;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setCompressionLevel(CompressionLevel compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public VectorDataType getVectorDataType() {
        return this.vectorDataType;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public Settings getIndexSettings() {
        return this.indexSettings;
    }

    public Version<?> getVersionCreated() {
        return this.versionCreated;
    }

    public Mode getMode() {
        return this.mode;
    }

    public CompressionLevel getCompressionLevel() {
        return this.compressionLevel;
    }

    public boolean equals(Object o) {
        Mode other_mode;
        Version<?> other_versionCreated;
        Settings other_indexSettings;
        VectorDataType other_vectorDataType;
        Integer other_dimension;
        if (o == this) {
            return true;
        }
        if (!(o instanceof KNNMethodConfigContext)) {
            return false;
        }
        KNNMethodConfigContext other = (KNNMethodConfigContext)o;
        Integer this_dimension = this.getDimension();
        if (!Objects.equals(this_dimension, other_dimension = other.getDimension())) {
            return false;
        }
        VectorDataType this_vectorDataType = this.getVectorDataType();
        if (!Objects.equals((Object)this_vectorDataType, (Object)(other_vectorDataType = other.getVectorDataType()))) {
            return false;
        }
        Settings this_indexSettings = this.getIndexSettings();
        if (!Objects.equals(this_indexSettings, other_indexSettings = other.getIndexSettings())) {
            return false;
        }
        Version<?> this_versionCreated = this.getVersionCreated();
        if (!Objects.equals(this_versionCreated, other_versionCreated = other.getVersionCreated())) {
            return false;
        }
        Mode this_mode = this.getMode();
        if (!Objects.equals((Object)this_mode, (Object)(other_mode = other.getMode()))) {
            return false;
        }
        CompressionLevel this_compressionLevel = this.getCompressionLevel();
        CompressionLevel other_compressionLevel = other.getCompressionLevel();
        return Objects.equals((Object)this_compressionLevel, (Object)other_compressionLevel);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : ((Object)$dimension).hashCode());
        VectorDataType $vectorDataType = this.getVectorDataType();
        result = result * 59 + ($vectorDataType == null ? 43 : ((Object)((Object)$vectorDataType)).hashCode());
        Settings $indexSettings = this.getIndexSettings();
        result = result * 59 + ($indexSettings == null ? 43 : $indexSettings.hashCode());
        Version<?> $versionCreated = this.getVersionCreated();
        result = result * 59 + ($versionCreated == null ? 43 : $versionCreated.hashCode());
        Mode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        CompressionLevel $compressionLevel = this.getCompressionLevel();
        result = result * 59 + ($compressionLevel == null ? 43 : ((Object)((Object)$compressionLevel)).hashCode());
        return result;
    }

    public static class KNNMethodConfigContextBuilder {
        private VectorDataType vectorDataType;
        private Integer dimension;
        private Settings indexSettings;
        private Version<?> versionCreated;
        private boolean mode$set;
        private Mode mode$value;
        private boolean compressionLevel$set;
        private CompressionLevel compressionLevel$value;

        KNNMethodConfigContextBuilder() {
        }

        public KNNMethodConfigContextBuilder vectorDataType(VectorDataType vectorDataType) {
            this.vectorDataType = vectorDataType;
            return this;
        }

        public KNNMethodConfigContextBuilder dimension(Integer dimension) {
            this.dimension = dimension;
            return this;
        }

        public KNNMethodConfigContextBuilder indexSettings(Settings indexSettings) {
            this.indexSettings = indexSettings;
            return this;
        }

        public KNNMethodConfigContextBuilder versionCreated(Version<?> versionCreated) {
            this.versionCreated = versionCreated;
            return this;
        }

        public KNNMethodConfigContextBuilder mode(Mode mode) {
            this.mode$value = mode;
            this.mode$set = true;
            return this;
        }

        public KNNMethodConfigContextBuilder compressionLevel(CompressionLevel compressionLevel) {
            this.compressionLevel$value = compressionLevel;
            this.compressionLevel$set = true;
            return this;
        }

        public KNNMethodConfigContext build() {
            Mode mode$value = this.mode$value;
            if (!this.mode$set) {
                mode$value = KNNMethodConfigContext.$default$mode();
            }
            CompressionLevel compressionLevel$value = this.compressionLevel$value;
            if (!this.compressionLevel$set) {
                compressionLevel$value = KNNMethodConfigContext.$default$compressionLevel();
            }
            return new KNNMethodConfigContext(this.vectorDataType, this.dimension, this.indexSettings, this.versionCreated, mode$value, compressionLevel$value);
        }

        public String toString() {
            return "KNNMethodConfigContext.KNNMethodConfigContextBuilder(vectorDataType=" + String.valueOf((Object)this.vectorDataType) + ", dimension=" + this.dimension + ", indexSettings=" + String.valueOf(this.indexSettings) + ", versionCreated=" + String.valueOf(this.versionCreated) + ", mode$value=" + String.valueOf((Object)this.mode$value) + ", compressionLevel$value=" + String.valueOf((Object)this.compressionLevel$value) + ")";
        }
    }
}

