/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.engine.AbstractKNNLibrary;
import org.opensearch.knn.index.engine.KNNMethod;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;

public abstract class NativeLibrary
extends AbstractKNNLibrary {
    private final Map<SpaceType, Function<Float, Float>> scoreTranslation;
    private final String extension;
    private final AtomicBoolean initialized;

    public NativeLibrary(Map<String, KNNMethod> methods, Map<SpaceType, Function<Float, Float>> scoreTranslation, String version, String extension) {
        super(methods, version);
        this.scoreTranslation = scoreTranslation;
        this.extension = extension;
        this.initialized = new AtomicBoolean(false);
    }

    @Override
    public String getCompoundExtension() {
        return this.getExtension() + "c";
    }

    @Override
    public float score(float rawScore, SpaceType spaceType) {
        if (this.scoreTranslation.containsKey((Object)spaceType)) {
            return this.scoreTranslation.get((Object)spaceType).apply(Float.valueOf(rawScore)).floatValue();
        }
        return spaceType.scoreTranslation(rawScore);
    }

    @Override
    public int estimateOverheadInKB(KNNMethodContext knnMethodContext, KNNMethodConfigContext knnMethodConfigContext) {
        String methodName = knnMethodContext.getMethodComponentContext().getName();
        return ((KNNMethod)this.methods.get(methodName)).estimateOverheadInKB(knnMethodContext, knnMethodConfigContext);
    }

    @Override
    public Boolean isInitialized() {
        return this.initialized.get();
    }

    @Override
    public void setInitialized(Boolean isInitialized) {
        Objects.requireNonNull(isInitialized, "isInitialized must not be null");
        this.initialized.set(isInitialized);
    }

    @Override
    public String getExtension() {
        return this.extension;
    }
}

