/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine.faiss;

import io.skylite.common.ValidationException;
import org.opensearch.knn.index.engine.Encoder;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.mapper.CompressionLevel;

public abstract class AbstractFaissPQEncoder
implements Encoder {
    @Override
    public CompressionLevel calculateCompressionLevel(MethodComponentContext methodComponentContext, KNNMethodConfigContext knnMethodConfigContext) {
        if (!methodComponentContext.getParameters().containsKey("m") || !methodComponentContext.getParameters().containsKey("code_size")) {
            return CompressionLevel.NOT_CONFIGURED;
        }
        Object value = methodComponentContext.getParameters().get("m");
        ValidationException validationException = this.getMethodComponent().getParameters().get("m").validate(value, knnMethodConfigContext);
        if (validationException != null) {
            throw validationException;
        }
        Integer m = (Integer)value;
        value = methodComponentContext.getParameters().get("code_size");
        validationException = this.getMethodComponent().getParameters().get("code_size").validate(value, knnMethodConfigContext);
        if (validationException != null) {
            throw validationException;
        }
        Integer codeSize = (Integer)value;
        int dimension = knnMethodConfigContext.getDimension();
        float actualCompression = (float)dimension * 32.0f / (float)(m * codeSize);
        if (actualCompression < 2.0f) {
            return CompressionLevel.x1;
        }
        if (actualCompression < 4.0f) {
            return CompressionLevel.x2;
        }
        if (actualCompression < 8.0f) {
            return CompressionLevel.x4;
        }
        if (actualCompression < 16.0f) {
            return CompressionLevel.x8;
        }
        if (actualCompression < 32.0f) {
            return CompressionLevel.x16;
        }
        if (actualCompression < 64.0f) {
            return CompressionLevel.x32;
        }
        return CompressionLevel.MAX_COMPRESSION_LEVEL;
    }
}

