/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.core.settings.Settings;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.KnnCircuitBreakerException;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.codec.util.KNNVectorSerializerFactory;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.mapper.KNNVectorFieldType;
import org.opensearch.knn.index.util.IndexHyperParametersUtil;

public class KNNVectorFieldMapperUtil {
    private static final Logger log = LogManager.getLogger(KNNVectorFieldMapperUtil.class);

    private KNNVectorFieldMapperUtil() {
    }

    public static FieldType buildDocValuesFieldType(KNNEngine knnEngine) {
        FieldType field = new FieldType();
        field.putAttribute("engine", knnEngine.getName());
        field.setDocValuesType(DocValuesType.BINARY);
        field.freeze();
        return field;
    }

    public static StoredField createStoredFieldForByteVector(String name, byte[] vector) {
        return new StoredField(name, vector);
    }

    public static StoredField createStoredFieldForFloatVector(String name, float[] vector) {
        return new StoredField(name, KNNVectorSerializerFactory.getDefaultSerializer().floatToByteArray(vector));
    }

    public static Object deserializeStoredVector(BytesRef storedVector, VectorDataType vectorDataType) {
        if (VectorDataType.BYTE == vectorDataType) {
            byte[] bytes = storedVector.bytes;
            int[] byteAsIntArray = new int[bytes.length];
            Arrays.setAll(byteAsIntArray, i -> bytes[i]);
            return byteAsIntArray;
        }
        return vectorDataType.getVectorFromBytesRef(storedVector);
    }

    public static int getExpectedVectorLength(KNNVectorFieldType knnVectorFieldType) {
        int expectedDimensions = knnVectorFieldType.getKnnMappingConfig().getDimension();
        return VectorDataType.BINARY == knnVectorFieldType.getVectorDataType() ? expectedDimensions / 8 : expectedDimensions;
    }

    static void validateIfCircuitBreakerIsNotTriggered() {
        if (KNNSettings.isCircuitBreakerTriggered()) {
            throw new KnnCircuitBreakerException("Parsing the created knn vector fields prior to indexing has failed as the circuit breaker triggered.  This indicates that the cluster is low on memory resources and cannot index more documents at the moment. Check _plugins/_knn/stats for the circuit breaker status.");
        }
    }

    static void validateIfKNNPluginEnabled() {
        if (!KNNSettings.isKNNPluginEnabled()) {
            throw new IllegalStateException("KNN plugin is disabled. To enable update knn.plugin.enabled setting to true");
        }
    }

    static boolean useLuceneKNNVectorsFormat(Version indexCreatedVersion) {
        return indexCreatedVersion.onOrAfter((Version)OpenSearchVersion.fromId((int)2170099));
    }

    private static SpaceType getSpaceType(Settings indexSettings) {
        String spaceType = indexSettings.get(KNNSettings.INDEX_KNN_SPACE_TYPE.getKey());
        if (spaceType == null) {
            spaceType = "l2";
            log.info(String.format(Locale.ROOT, "[KNN] The setting \"%s\" was not set for the index. Likely caused by recent version upgrade. Setting the setting to the default value=%s", "space_type", spaceType));
        }
        return SpaceType.getSpace(spaceType);
    }

    private static int getM(Settings indexSettings) {
        String m = indexSettings.get(KNNSettings.INDEX_KNN_ALGO_PARAM_M_SETTING.getKey());
        if (m == null) {
            log.info(String.format("[KNN] The setting \"%s\" was not set for the index. Likely caused by recent version upgrade. Setting the setting to the default value=%s", "M", KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_M));
            return KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_M;
        }
        return Integer.parseInt(m);
    }

    private static int getEfConstruction(Settings indexSettings, Version<?> indexVersion) {
        String efConstruction = indexSettings.get(KNNSettings.INDEX_KNN_ALGO_PARAM_EF_CONSTRUCTION_SETTING.getKey());
        if (efConstruction == null) {
            int defaultEFConstructionValue = IndexHyperParametersUtil.getHNSWEFConstructionValue(indexVersion);
            log.info(String.format("[KNN] The setting \"%s\" was not set for the index. Likely caused by recent version upgrade. Picking up default value for the index =%s", "efConstruction", defaultEFConstructionValue));
            return defaultEFConstructionValue;
        }
        return Integer.parseInt(efConstruction);
    }

    static KNNMethodContext createKNNMethodContextFromLegacy(Settings indexSettings, Version indexCreatedVersion, SpaceType topLevelSpaceType) {
        SpaceType finalSpaceToSet = topLevelSpaceType != SpaceType.UNDEFINED ? topLevelSpaceType : KNNVectorFieldMapperUtil.getSpaceType(indexSettings);
        return new KNNMethodContext(KNNEngine.NMSLIB, finalSpaceToSet, new MethodComponentContext("hnsw", Map.of("m", KNNVectorFieldMapperUtil.getM(indexSettings), "ef_construction", KNNVectorFieldMapperUtil.getEfConstruction(indexSettings, indexCreatedVersion))));
    }
}

