/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.KNNVectorIndexFieldData;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.KNNMappingConfig;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapperUtil;
import org.opensearch.knn.index.mapper.Mode;
import org.opensearch.knn.index.query.rescore.RescoreContext;

public class KNNVectorFieldType
extends MappedFieldType {
    KNNMappingConfig knnMappingConfig;
    VectorDataType vectorDataType;

    public KNNVectorFieldType(String name, Map<String, String> metadata, VectorDataType vectorDataType, KNNMappingConfig annConfig) {
        super(name, false, false, true, TextSearchInfo.NONE, metadata);
        this.vectorDataType = vectorDataType;
        this.knnMappingConfig = annConfig;
    }

    public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
        throw new UnsupportedOperationException("KNN Vector do not support fields search");
    }

    public String typeName() {
        return "knn_vector";
    }

    public Query existsQuery(QueryShardContext context) {
        return new FieldExistsQuery(this.name());
    }

    public Query termQuery(Object value, QueryShardContext context) {
        throw new QueryShardException(context.index(), String.format(Locale.ROOT, "KNN vector do not support exact searching, use KNN queries instead: [%s]", this.name()), new Object[0]);
    }

    public BaseIndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
        this.failIfNoDocValues();
        return new KNNVectorIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.BYTES, this.vectorDataType);
    }

    public Object valueForDisplay(Object value) {
        return KNNVectorFieldMapperUtil.deserializeStoredVector((BytesRef)value, this.vectorDataType);
    }

    public RescoreContext resolveRescoreContext(RescoreContext userProvidedContext) {
        if (userProvidedContext != null) {
            return userProvidedContext;
        }
        KNNMappingConfig knnMappingConfig = this.getKnnMappingConfig();
        int dimension = knnMappingConfig.getDimension();
        CompressionLevel compressionLevel = knnMappingConfig.getCompressionLevel();
        Mode mode = knnMappingConfig.getMode();
        return compressionLevel.getDefaultRescoreContext(mode, dimension);
    }

    public KNNMappingConfig getKnnMappingConfig() {
        return this.knnMappingConfig;
    }

    public VectorDataType getVectorDataType() {
        return this.vectorDataType;
    }
}

