/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import io.skylite.common.Explicit;
import io.skylite.core.mapper.FieldMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.KnnByteVectorField;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.index.IndexableFieldType;
import org.opensearch.knn.index.KNNVectorSimilarityFunction;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.VectorField;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.KNNMappingConfig;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapperUtil;
import org.opensearch.knn.index.mapper.KNNVectorFieldType;
import org.opensearch.knn.index.mapper.Mode;
import org.opensearch.knn.index.mapper.OriginalMappingParameters;
import org.opensearch.knn.index.mapper.PerDimensionProcessor;
import org.opensearch.knn.index.mapper.PerDimensionValidator;
import org.opensearch.knn.index.mapper.VectorValidator;

public class LuceneFieldMapper
extends KNNVectorFieldMapper {
    private final FieldType vectorFieldType;
    private final PerDimensionProcessor perDimensionProcessor;
    private final PerDimensionValidator perDimensionValidator;
    private final VectorValidator vectorValidator;

    static LuceneFieldMapper createFieldMapper(String fullname, Map<String, String> metaValue, final KNNMethodConfigContext knnMethodConfigContext, CreateLuceneFieldMapperInput createLuceneFieldMapperInput, final OriginalMappingParameters originalMappingParameters) {
        KNNVectorFieldType mappedFieldType = new KNNVectorFieldType(fullname, metaValue, knnMethodConfigContext.getVectorDataType(), new KNNMappingConfig(){

            @Override
            public Optional<KNNMethodContext> getKnnMethodContext() {
                return Optional.of(originalMappingParameters.getResolvedKnnMethodContext());
            }

            @Override
            public int getDimension() {
                return knnMethodConfigContext.getDimension();
            }

            @Override
            public Mode getMode() {
                return knnMethodConfigContext.getMode();
            }

            @Override
            public CompressionLevel getCompressionLevel() {
                return knnMethodConfigContext.getCompressionLevel();
            }
        });
        return new LuceneFieldMapper(mappedFieldType, createLuceneFieldMapperInput, knnMethodConfigContext, originalMappingParameters);
    }

    private LuceneFieldMapper(KNNVectorFieldType mappedFieldType, CreateLuceneFieldMapperInput input, KNNMethodConfigContext knnMethodConfigContext, OriginalMappingParameters originalMappingParameters) {
        super(input.getName(), mappedFieldType, input.getMultiFields(), input.getCopyTo(), input.getIgnoreMalformed(), input.isStored(), input.isHasDocValues(), knnMethodConfigContext.getVersionCreated(), originalMappingParameters, knnMethodConfigContext.getIndexSettings());
        KNNMappingConfig knnMappingConfig = mappedFieldType.getKnnMappingConfig();
        KNNMethodContext resolvedKnnMethodContext = originalMappingParameters.getResolvedKnnMethodContext();
        VectorDataType vectorDataType = mappedFieldType.getVectorDataType();
        KNNVectorSimilarityFunction vectorSimilarityFunction = resolvedKnnMethodContext.getSpaceType().getKnnVectorSimilarityFunction();
        this.fieldType = vectorDataType.createKnnVectorFieldType(knnMappingConfig.getDimension(), vectorSimilarityFunction);
        this.vectorFieldType = this.hasDocValues ? KNNVectorFieldMapperUtil.buildDocValuesFieldType(resolvedKnnMethodContext.getKnnEngine()) : null;
        KNNLibraryIndexingContext knnLibraryIndexingContext = resolvedKnnMethodContext.getKnnEngine().getKNNLibraryIndexingContext(resolvedKnnMethodContext, knnMethodConfigContext);
        this.perDimensionProcessor = knnLibraryIndexingContext.getPerDimensionProcessor();
        this.perDimensionValidator = knnLibraryIndexingContext.getPerDimensionValidator();
        this.vectorValidator = knnLibraryIndexingContext.getVectorValidator();
    }

    @Override
    protected List<Field> getFieldsForFloatVector(float[] array) {
        ArrayList<Field> fieldsToBeAdded = new ArrayList<Field>();
        fieldsToBeAdded.add((Field)new KnnFloatVectorField(this.name(), array, this.fieldType));
        if (this.hasDocValues && this.vectorFieldType != null) {
            fieldsToBeAdded.add(new VectorField(this.name(), array, (IndexableFieldType)this.vectorFieldType));
        }
        if (this.stored) {
            fieldsToBeAdded.add((Field)KNNVectorFieldMapperUtil.createStoredFieldForFloatVector(this.name(), array));
        }
        return fieldsToBeAdded;
    }

    @Override
    protected List<Field> getFieldsForByteVector(byte[] array) {
        ArrayList<Field> fieldsToBeAdded = new ArrayList<Field>();
        fieldsToBeAdded.add((Field)new KnnByteVectorField(this.name(), array, this.fieldType));
        if (this.hasDocValues && this.vectorFieldType != null) {
            fieldsToBeAdded.add(new VectorField(this.name(), array, (IndexableFieldType)this.vectorFieldType));
        }
        if (this.stored) {
            fieldsToBeAdded.add((Field)KNNVectorFieldMapperUtil.createStoredFieldForByteVector(this.name(), array));
        }
        return fieldsToBeAdded;
    }

    @Override
    protected VectorValidator getVectorValidator() {
        return this.vectorValidator;
    }

    @Override
    protected PerDimensionValidator getPerDimensionValidator() {
        return this.perDimensionValidator;
    }

    @Override
    protected PerDimensionProcessor getPerDimensionProcessor() {
        return this.perDimensionProcessor;
    }

    @Override
    void updateEngineStats() {
        KNNEngine.LUCENE.setInitialized(true);
    }

    static class CreateLuceneFieldMapperInput {
        String name;
        FieldMapper.MultiFields multiFields;
        FieldMapper.CopyTo copyTo;
        Explicit<Boolean> ignoreMalformed;
        boolean stored;
        boolean hasDocValues;
        KNNMethodContext originalKnnMethodContext;

        public static CreateLuceneFieldMapperInputBuilder builder() {
            return new CreateLuceneFieldMapperInputBuilder();
        }

        public CreateLuceneFieldMapperInput(String name, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, KNNMethodContext originalKnnMethodContext) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (multiFields == null) {
                throw new NullPointerException("multiFields is marked non-null but is null");
            }
            if (copyTo == null) {
                throw new NullPointerException("copyTo is marked non-null but is null");
            }
            if (ignoreMalformed == null) {
                throw new NullPointerException("ignoreMalformed is marked non-null but is null");
            }
            this.name = name;
            this.multiFields = multiFields;
            this.copyTo = copyTo;
            this.ignoreMalformed = ignoreMalformed;
            this.stored = stored;
            this.hasDocValues = hasDocValues;
            this.originalKnnMethodContext = originalKnnMethodContext;
        }

        public String getName() {
            return this.name;
        }

        public FieldMapper.MultiFields getMultiFields() {
            return this.multiFields;
        }

        public FieldMapper.CopyTo getCopyTo() {
            return this.copyTo;
        }

        public Explicit<Boolean> getIgnoreMalformed() {
            return this.ignoreMalformed;
        }

        public boolean isStored() {
            return this.stored;
        }

        public boolean isHasDocValues() {
            return this.hasDocValues;
        }

        public static class CreateLuceneFieldMapperInputBuilder {
            private String name;
            private FieldMapper.MultiFields multiFields;
            private FieldMapper.CopyTo copyTo;
            private Explicit<Boolean> ignoreMalformed;
            private boolean stored;
            private boolean hasDocValues;
            private KNNMethodContext originalKnnMethodContext;

            CreateLuceneFieldMapperInputBuilder() {
            }

            public CreateLuceneFieldMapperInputBuilder name(String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            public CreateLuceneFieldMapperInputBuilder multiFields(FieldMapper.MultiFields multiFields) {
                if (multiFields == null) {
                    throw new NullPointerException("multiFields is marked non-null but is null");
                }
                this.multiFields = multiFields;
                return this;
            }

            public CreateLuceneFieldMapperInputBuilder copyTo(FieldMapper.CopyTo copyTo) {
                if (copyTo == null) {
                    throw new NullPointerException("copyTo is marked non-null but is null");
                }
                this.copyTo = copyTo;
                return this;
            }

            public CreateLuceneFieldMapperInputBuilder ignoreMalformed(Explicit<Boolean> ignoreMalformed) {
                if (ignoreMalformed == null) {
                    throw new NullPointerException("ignoreMalformed is marked non-null but is null");
                }
                this.ignoreMalformed = ignoreMalformed;
                return this;
            }

            public CreateLuceneFieldMapperInputBuilder stored(boolean stored) {
                this.stored = stored;
                return this;
            }

            public CreateLuceneFieldMapperInputBuilder hasDocValues(boolean hasDocValues) {
                this.hasDocValues = hasDocValues;
                return this;
            }

            public CreateLuceneFieldMapperInputBuilder originalKnnMethodContext(KNNMethodContext originalKnnMethodContext) {
                this.originalKnnMethodContext = originalKnnMethodContext;
                return this;
            }

            public CreateLuceneFieldMapperInput build() {
                return new CreateLuceneFieldMapperInput(this.name, this.multiFields, this.copyTo, this.ignoreMalformed, this.stored, this.hasDocValues, this.originalKnnMethodContext);
            }

            public String toString() {
                return "LuceneFieldMapper.CreateLuceneFieldMapperInput.CreateLuceneFieldMapperInputBuilder(name=" + this.name + ", multiFields=" + String.valueOf(this.multiFields) + ", copyTo=" + String.valueOf(this.copyTo) + ", ignoreMalformed=" + String.valueOf(this.ignoreMalformed) + ", stored=" + this.stored + ", hasDocValues=" + this.hasDocValues + ", originalKnnMethodContext=" + String.valueOf(this.originalKnnMethodContext) + ")";
            }
        }
    }
}

