/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import io.skylite.core.common.Strings;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;

public enum Mode {
    NOT_CONFIGURED(""),
    IN_MEMORY("in_memory"),
    ON_DISK("on_disk");

    public static final String[] NAMES_ARRAY;
    private static final Mode DEFAULT;
    private final String name;

    private Mode(String name) {
        this.name = name;
    }

    public static Mode fromName(String name) {
        if (Strings.isEmpty((CharSequence)name)) {
            return NOT_CONFIGURED;
        }
        if (Mode.IN_MEMORY.name.equalsIgnoreCase(name)) {
            return IN_MEMORY;
        }
        if (Mode.ON_DISK.name.equalsIgnoreCase(name)) {
            return ON_DISK;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid mode: \"[%s]\"", name));
    }

    public static boolean isConfigured(Mode mode) {
        return mode != null && mode != NOT_CONFIGURED;
    }

    public String getName() {
        return this.name;
    }

    static {
        NAMES_ARRAY = Arrays.stream(Mode.values()).map(mode -> mode == NOT_CONFIGURED ? null : mode.getName()).collect(Collectors.toList()).toArray(new String[0]);
        DEFAULT = IN_MEMORY;
    }
}

