/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.quantizationservice;

import java.io.IOException;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.quantization.models.requests.TrainingRequest;

final class KNNVectorQuantizationTrainingRequest<T>
extends TrainingRequest<T> {
    private final KNNVectorValues<T> knnVectorValues;
    private int lastIndex;

    KNNVectorQuantizationTrainingRequest(KNNVectorValues<T> knnVectorValues, long liveDocs) {
        super((int)liveDocs);
        this.knnVectorValues = knnVectorValues;
        this.lastIndex = 0;
    }

    @Override
    public T getVectorAtThePosition(int position) throws IOException {
        while (this.lastIndex <= position) {
            ++this.lastIndex;
            if (this.knnVectorValues.docId() == Integer.MAX_VALUE) {
                return null;
            }
            this.knnVectorValues.nextDoc();
        }
        return this.knnVectorValues.getVector();
    }
}

