/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.quantizationservice;

import java.io.IOException;
import org.apache.lucene.index.FieldInfo;
import org.opensearch.knn.common.FieldInfoExtractor;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;
import org.opensearch.knn.index.quantizationservice.KNNVectorQuantizationTrainingRequest;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.quantization.factory.QuantizerFactory;
import org.opensearch.knn.quantization.models.quantizationOutput.BinaryQuantizationOutput;
import org.opensearch.knn.quantization.models.quantizationOutput.QuantizationOutput;
import org.opensearch.knn.quantization.models.quantizationParams.QuantizationParams;
import org.opensearch.knn.quantization.models.quantizationParams.ScalarQuantizationParams;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationState;
import org.opensearch.knn.quantization.quantizer.Quantizer;

public final class QuantizationService<T, R> {
    private static final QuantizationService<?, ?> INSTANCE = new QuantizationService();

    private QuantizationService() {
    }

    public static <T, R> QuantizationService<T, R> getInstance() {
        return INSTANCE;
    }

    public QuantizationState train(QuantizationParams quantizationParams, KNNVectorValues<T> knnVectorValues, long liveDocs) throws IOException {
        Quantizer quantizer = QuantizerFactory.getQuantizer(quantizationParams);
        KNNVectorQuantizationTrainingRequest<T> trainingRequest = new KNNVectorQuantizationTrainingRequest<T>(knnVectorValues, liveDocs);
        return quantizer.train(trainingRequest);
    }

    public R quantize(QuantizationState quantizationState, T vector, QuantizationOutput<R> quantizationOutput) {
        Quantizer<T, R> quantizer = QuantizerFactory.getQuantizer(quantizationState.getQuantizationParams());
        quantizer.quantize(vector, quantizationState, quantizationOutput);
        return quantizationOutput.getQuantizedVector();
    }

    public QuantizationParams getQuantizationParams(FieldInfo fieldInfo) {
        QuantizationConfig quantizationConfig = FieldInfoExtractor.extractQuantizationConfig(fieldInfo);
        if (quantizationConfig != QuantizationConfig.EMPTY && quantizationConfig.getQuantizationType() != null) {
            return new ScalarQuantizationParams(quantizationConfig.getQuantizationType());
        }
        return null;
    }

    public VectorDataType getVectorDataTypeForTransfer(FieldInfo fieldInfo) {
        QuantizationConfig quantizationConfig = FieldInfoExtractor.extractQuantizationConfig(fieldInfo);
        if (quantizationConfig != QuantizationConfig.EMPTY && quantizationConfig.getQuantizationType() != null) {
            return VectorDataType.BINARY;
        }
        return null;
    }

    public QuantizationOutput<R> createQuantizationOutput(QuantizationParams quantizationParams) {
        if (quantizationParams instanceof ScalarQuantizationParams) {
            ScalarQuantizationParams scalarParams = (ScalarQuantizationParams)quantizationParams;
            return new BinaryQuantizationOutput(scalarParams.getSqType().getId());
        }
        throw new IllegalArgumentException("Unsupported quantization parameters: " + quantizationParams.getClass().getName());
    }
}

