/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.opensearch.index.search.NestedHelper;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.query.rescore.RescoreContext;

public abstract class BaseQueryFactory {
    private static final Logger log = LogManager.getLogger(BaseQueryFactory.class);

    protected static Query getFilterQuery(CreateQueryRequest createQueryRequest) {
        Query filterQuery;
        if (!createQueryRequest.getFilter().isPresent()) {
            return null;
        }
        QueryShardContext queryShardContext = createQueryRequest.getContext().orElseThrow(() -> new RuntimeException("Shard context cannot be null"));
        log.debug(String.format(Locale.ROOT, "Creating query with filter for index [%s], field [%s]", createQueryRequest.getIndexName(), createQueryRequest.getFieldName()));
        try {
            filterQuery = createQueryRequest.getFilter().get().toQuery((QueryRewriteContext)queryShardContext);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create query with filter", e);
        }
        BitSetProducer parentFilter = queryShardContext.getParentFilter();
        if (parentFilter != null) {
            boolean mightMatch = new NestedHelper(arg_0 -> ((QueryShardContext)queryShardContext).getObjectMapper(arg_0), arg_0 -> ((QueryShardContext)queryShardContext).isFieldMapped(arg_0)).mightMatchNestedDocs(filterQuery);
            if (mightMatch) {
                return filterQuery;
            }
            return new ToChildBlockJoinQuery(filterQuery, parentFilter);
        }
        return filterQuery;
    }

    public static class CreateQueryRequest {
        private KNNEngine knnEngine;
        private String indexName;
        private String fieldName;
        private float[] vector;
        private byte[] byteVector;
        private VectorDataType vectorDataType;
        private Map<String, ?> methodParameters;
        private Integer k;
        private Float radius;
        private QueryBuilder filter;
        private QueryShardContext context;
        private RescoreContext rescoreContext;
        private boolean expandNested;

        public Optional<QueryBuilder> getFilter() {
            return Optional.ofNullable(this.filter);
        }

        public Optional<QueryShardContext> getContext() {
            return Optional.ofNullable(this.context);
        }

        public Optional<RescoreContext> getRescoreContext() {
            return Optional.ofNullable(this.rescoreContext);
        }

        public static CreateQueryRequestBuilder builder() {
            return new CreateQueryRequestBuilder();
        }

        public CreateQueryRequest(KNNEngine knnEngine, String indexName, String fieldName, float[] vector, byte[] byteVector, VectorDataType vectorDataType, Map<String, ?> methodParameters, Integer k, Float radius, QueryBuilder filter, QueryShardContext context, RescoreContext rescoreContext, boolean expandNested) {
            if (knnEngine == null) {
                throw new NullPointerException("knnEngine is marked non-null but is null");
            }
            if (indexName == null) {
                throw new NullPointerException("indexName is marked non-null but is null");
            }
            this.knnEngine = knnEngine;
            this.indexName = indexName;
            this.fieldName = fieldName;
            this.vector = vector;
            this.byteVector = byteVector;
            this.vectorDataType = vectorDataType;
            this.methodParameters = methodParameters;
            this.k = k;
            this.radius = radius;
            this.filter = filter;
            this.context = context;
            this.rescoreContext = rescoreContext;
            this.expandNested = expandNested;
        }

        public KNNEngine getKnnEngine() {
            return this.knnEngine;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public float[] getVector() {
            return this.vector;
        }

        public byte[] getByteVector() {
            return this.byteVector;
        }

        public VectorDataType getVectorDataType() {
            return this.vectorDataType;
        }

        public Map<String, ?> getMethodParameters() {
            return this.methodParameters;
        }

        public Integer getK() {
            return this.k;
        }

        public Float getRadius() {
            return this.radius;
        }

        public boolean isExpandNested() {
            return this.expandNested;
        }

        public static class CreateQueryRequestBuilder {
            private KNNEngine knnEngine;
            private String indexName;
            private String fieldName;
            private float[] vector;
            private byte[] byteVector;
            private VectorDataType vectorDataType;
            private Map<String, ?> methodParameters;
            private Integer k;
            private Float radius;
            private QueryBuilder filter;
            private QueryShardContext context;
            private RescoreContext rescoreContext;
            private boolean expandNested;

            CreateQueryRequestBuilder() {
            }

            public CreateQueryRequestBuilder knnEngine(KNNEngine knnEngine) {
                if (knnEngine == null) {
                    throw new NullPointerException("knnEngine is marked non-null but is null");
                }
                this.knnEngine = knnEngine;
                return this;
            }

            public CreateQueryRequestBuilder indexName(String indexName) {
                if (indexName == null) {
                    throw new NullPointerException("indexName is marked non-null but is null");
                }
                this.indexName = indexName;
                return this;
            }

            public CreateQueryRequestBuilder fieldName(String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            public CreateQueryRequestBuilder vector(float[] vector) {
                this.vector = vector;
                return this;
            }

            public CreateQueryRequestBuilder byteVector(byte[] byteVector) {
                this.byteVector = byteVector;
                return this;
            }

            public CreateQueryRequestBuilder vectorDataType(VectorDataType vectorDataType) {
                this.vectorDataType = vectorDataType;
                return this;
            }

            public CreateQueryRequestBuilder methodParameters(Map<String, ?> methodParameters) {
                this.methodParameters = methodParameters;
                return this;
            }

            public CreateQueryRequestBuilder k(Integer k) {
                this.k = k;
                return this;
            }

            public CreateQueryRequestBuilder radius(Float radius) {
                this.radius = radius;
                return this;
            }

            public CreateQueryRequestBuilder filter(QueryBuilder filter) {
                this.filter = filter;
                return this;
            }

            public CreateQueryRequestBuilder context(QueryShardContext context) {
                this.context = context;
                return this;
            }

            public CreateQueryRequestBuilder rescoreContext(RescoreContext rescoreContext) {
                this.rescoreContext = rescoreContext;
                return this;
            }

            public CreateQueryRequestBuilder expandNested(boolean expandNested) {
                this.expandNested = expandNested;
                return this;
            }

            public CreateQueryRequest build() {
                return new CreateQueryRequest(this.knnEngine, this.indexName, this.fieldName, this.vector, this.byteVector, this.vectorDataType, this.methodParameters, this.k, this.radius, this.filter, this.context, this.rescoreContext, this.expandNested);
            }

            public String toString() {
                return "BaseQueryFactory.CreateQueryRequest.CreateQueryRequestBuilder(knnEngine=" + String.valueOf(this.knnEngine) + ", indexName=" + this.indexName + ", fieldName=" + this.fieldName + ", vector=" + Arrays.toString(this.vector) + ", byteVector=" + Arrays.toString(this.byteVector) + ", vectorDataType=" + String.valueOf((Object)this.vectorDataType) + ", methodParameters=" + String.valueOf(this.methodParameters) + ", k=" + this.k + ", radius=" + this.radius + ", filter=" + String.valueOf(this.filter) + ", context=" + String.valueOf(this.context) + ", rescoreContext=" + String.valueOf(this.rescoreContext) + ", expandNested=" + this.expandNested + ")";
            }
        }
    }
}

