/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.FixedBitSet;

public class FilterIdsSelector {
    long[] filterIds;
    private FilterIdsSelectorType filterType;

    public FilterIdsSelector(long[] filterIds, FilterIdsSelectorType filterType) {
        this.filterIds = filterIds;
        this.filterType = filterType;
    }

    public static FilterIdsSelector getFilterIdSelector(BitSet filterIdsBitSet, int cardinality) throws IOException {
        FilterIdsSelectorType filterType;
        long[] filterIds;
        if (filterIdsBitSet instanceof FixedBitSet) {
            filterIds = ((FixedBitSet)filterIdsBitSet).getBits();
            filterType = FilterIdsSelectorType.BITMAP;
        } else if (cardinality * 8 * 8 <= filterIdsBitSet.length()) {
            BitSetIterator bitSetIterator = new BitSetIterator(filterIdsBitSet, (long)cardinality);
            filterIds = new long[cardinality];
            int idx = 0;
            int docId = bitSetIterator.nextDoc();
            while (docId != Integer.MAX_VALUE) {
                filterIds[idx++] = docId;
                docId = bitSetIterator.nextDoc();
            }
            filterType = FilterIdsSelectorType.BATCH;
        } else {
            FixedBitSet fixedBitSet = new FixedBitSet(filterIdsBitSet.length());
            BitSetIterator sparseBitSetIterator = new BitSetIterator(filterIdsBitSet, (long)cardinality);
            fixedBitSet.or((DocIdSetIterator)sparseBitSetIterator);
            filterIds = fixedBitSet.getBits();
            filterType = FilterIdsSelectorType.BITMAP;
        }
        return new FilterIdsSelector(filterIds, filterType);
    }

    public long[] getFilterIds() {
        return this.filterIds;
    }

    public FilterIdsSelectorType getFilterType() {
        return this.filterType;
    }

    public static enum FilterIdsSelectorType {
        BITMAP(0),
        BATCH(1);

        private final int value;

        private FilterIdsSelectorType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

