/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.query.KNNWeight;
import org.opensearch.knn.index.query.rescore.RescoreContext;

public class KNNQuery
extends Query {
    private final String field;
    private final float[] queryVector;
    private final byte[] byteQueryVector;
    private int k;
    private Map<String, ?> methodParameters;
    private final String indexName;
    private final VectorDataType vectorDataType;
    private final RescoreContext rescoreContext;
    private Query filterQuery;
    private BitSetProducer parentsFilter;
    private Float radius;
    private Context context;

    public KNNQuery(String field, float[] queryVector, int k, String indexName, BitSetProducer parentsFilter) {
        this(field, queryVector, null, k, indexName, null, parentsFilter, VectorDataType.FLOAT, null);
    }

    public KNNQuery(String field, float[] queryVector, int k, String indexName, Query filterQuery, BitSetProducer parentsFilter, RescoreContext rescoreContext) {
        this(field, queryVector, null, k, indexName, filterQuery, parentsFilter, VectorDataType.FLOAT, rescoreContext);
    }

    public KNNQuery(String field, byte[] byteQueryVector, int k, String indexName, Query filterQuery, BitSetProducer parentsFilter, VectorDataType vectorDataType, RescoreContext rescoreContext) {
        this(field, null, byteQueryVector, k, indexName, filterQuery, parentsFilter, vectorDataType, rescoreContext);
    }

    private KNNQuery(String field, float[] queryVector, byte[] byteQueryVector, int k, String indexName, Query filterQuery, BitSetProducer parentsFilter, VectorDataType vectorDataType, RescoreContext rescoreContext) {
        this.field = field;
        this.queryVector = queryVector;
        this.byteQueryVector = byteQueryVector;
        this.k = k;
        this.indexName = indexName;
        this.filterQuery = filterQuery;
        this.parentsFilter = parentsFilter;
        this.vectorDataType = vectorDataType;
        this.rescoreContext = rescoreContext;
    }

    public KNNQuery(String field, float[] queryVector, byte[] byteQueryVector, int k, Map<String, ?> methodParameters, String indexName, VectorDataType vectorDataType, RescoreContext rescoreContext, Query filterQuery, BitSetProducer parentsFilter, Float radius, Context context) {
        this.field = field;
        this.queryVector = queryVector;
        this.byteQueryVector = byteQueryVector;
        this.k = k;
        this.methodParameters = methodParameters;
        this.indexName = indexName;
        this.vectorDataType = vectorDataType;
        this.rescoreContext = rescoreContext;
        this.filterQuery = filterQuery;
        this.parentsFilter = parentsFilter;
        this.radius = radius;
        this.context = context;
    }

    public KNNQuery(String field, float[] queryVector, String indexName, BitSetProducer parentsFilter) {
        this(field, queryVector, null, 0, indexName, null, parentsFilter, VectorDataType.FLOAT, null);
    }

    public KNNQuery radius(Float radius) {
        this.radius = radius;
        return this;
    }

    public KNNQuery kNNQueryContext(Context context) {
        this.context = context;
        return this;
    }

    public KNNQuery filterQuery(Query filterQuery) {
        this.filterQuery = filterQuery;
        return this;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        if (!KNNSettings.isKNNPluginEnabled()) {
            throw new IllegalStateException("KNN plugin is disabled. To enable update knn.plugin.enabled to true");
        }
        Weight filterWeight = this.getFilterWeight(searcher);
        if (filterWeight != null) {
            return new KNNWeight(this, boost, filterWeight);
        }
        return new KNNWeight(this, boost);
    }

    private Weight getFilterWeight(IndexSearcher searcher) throws IOException {
        if (this.getFilterQuery() != null) {
            BooleanQuery booleanQuery = new BooleanQuery.Builder().add(this.getFilterQuery(), BooleanClause.Occur.FILTER).add((Query)new FieldExistsQuery(this.getField()), BooleanClause.Occur.FILTER).build();
            Query rewritten = searcher.rewrite((Query)booleanQuery);
            return searcher.createWeight(rewritten, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        }
        return null;
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public String toString(String field) {
        return field;
    }

    public int hashCode() {
        return Objects.hash(this.field, Arrays.hashCode(this.queryVector), this.k, this.indexName, this.filterQuery, this.context, this.parentsFilter, this.radius, this.methodParameters, this.rescoreContext);
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((KNNQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(KNNQuery other) {
        if (other == this) {
            return true;
        }
        return Objects.equals(this.field, other.field) && Arrays.equals(this.queryVector, other.queryVector) && Arrays.equals(this.byteQueryVector, other.byteQueryVector) && Objects.equals(this.k, other.k) && Objects.equals(this.methodParameters, other.methodParameters) && Objects.equals(this.radius, other.radius) && Objects.equals(this.context, other.context) && Objects.equals(this.indexName, other.indexName) && Objects.equals(this.parentsFilter, other.parentsFilter) && Objects.equals(this.filterQuery, other.filterQuery) && Objects.equals(this.rescoreContext, other.rescoreContext);
    }

    public static KNNQueryBuilder builder() {
        return new KNNQueryBuilder();
    }

    public String getField() {
        return this.field;
    }

    public float[] getQueryVector() {
        return this.queryVector;
    }

    public byte[] getByteQueryVector() {
        return this.byteQueryVector;
    }

    public int getK() {
        return this.k;
    }

    public Map<String, ?> getMethodParameters() {
        return this.methodParameters;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public VectorDataType getVectorDataType() {
        return this.vectorDataType;
    }

    public RescoreContext getRescoreContext() {
        return this.rescoreContext;
    }

    public Query getFilterQuery() {
        return this.filterQuery;
    }

    public Float getRadius() {
        return this.radius;
    }

    public Context getContext() {
        return this.context;
    }

    public void setFilterQuery(Query filterQuery) {
        this.filterQuery = filterQuery;
    }

    public BitSetProducer getParentsFilter() {
        return this.parentsFilter;
    }

    public static class Context {
        int maxResultWindow;

        public void setMaxResultWindow(int maxResultWindow) {
            this.maxResultWindow = maxResultWindow;
        }

        public int getMaxResultWindow() {
            return this.maxResultWindow;
        }

        public Context(int maxResultWindow) {
            this.maxResultWindow = maxResultWindow;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context other = (Context)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getMaxResultWindow() == other.getMaxResultWindow();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Context;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxResultWindow();
            return result;
        }
    }

    public static class KNNQueryBuilder {
        private String field;
        private float[] queryVector;
        private byte[] byteQueryVector;
        private int k;
        private Map<String, ?> methodParameters;
        private String indexName;
        private VectorDataType vectorDataType;
        private RescoreContext rescoreContext;
        private Query filterQuery;
        private BitSetProducer parentsFilter;
        private Float radius;
        private Context context;

        KNNQueryBuilder() {
        }

        public KNNQueryBuilder field(String field) {
            this.field = field;
            return this;
        }

        public KNNQueryBuilder queryVector(float[] queryVector) {
            this.queryVector = queryVector;
            return this;
        }

        public KNNQueryBuilder byteQueryVector(byte[] byteQueryVector) {
            this.byteQueryVector = byteQueryVector;
            return this;
        }

        public KNNQueryBuilder k(int k) {
            this.k = k;
            return this;
        }

        public KNNQueryBuilder methodParameters(Map<String, ?> methodParameters) {
            this.methodParameters = methodParameters;
            return this;
        }

        public KNNQueryBuilder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public KNNQueryBuilder vectorDataType(VectorDataType vectorDataType) {
            this.vectorDataType = vectorDataType;
            return this;
        }

        public KNNQueryBuilder rescoreContext(RescoreContext rescoreContext) {
            this.rescoreContext = rescoreContext;
            return this;
        }

        public KNNQueryBuilder filterQuery(Query filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public KNNQueryBuilder parentsFilter(BitSetProducer parentsFilter) {
            this.parentsFilter = parentsFilter;
            return this;
        }

        public KNNQueryBuilder radius(Float radius) {
            this.radius = radius;
            return this;
        }

        public KNNQueryBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public KNNQuery build() {
            return new KNNQuery(this.field, this.queryVector, this.byteQueryVector, this.k, this.methodParameters, this.indexName, this.vectorDataType, this.rescoreContext, this.filterQuery, this.parentsFilter, this.radius, this.context);
        }

        public String toString() {
            return "KNNQuery.KNNQueryBuilder(field=" + this.field + ", queryVector=" + Arrays.toString(this.queryVector) + ", byteQueryVector=" + Arrays.toString(this.byteQueryVector) + ", k=" + this.k + ", methodParameters=" + String.valueOf(this.methodParameters) + ", indexName=" + this.indexName + ", vectorDataType=" + String.valueOf((Object)this.vectorDataType) + ", rescoreContext=" + String.valueOf(this.rescoreContext) + ", filterQuery=" + String.valueOf(this.filterQuery) + ", parentsFilter=" + String.valueOf(this.parentsFilter) + ", radius=" + this.radius + ", context=" + String.valueOf(this.context) + ")";
        }
    }
}

