/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;

public class KNNScorer
extends Scorer {
    private final DocIdSetIterator docIdsIter;
    private final Map<Integer, Float> scores;
    private final float boost;
    private static final Scorer EMPTY_SCORER_INSTANCE = new Scorer(){
        private final DocIdSetIterator docIdsIter = DocIdSetIterator.empty();

        public DocIdSetIterator iterator() {
            return this.docIdsIter;
        }

        public float getMaxScore(int upTo) throws IOException {
            return 0.0f;
        }

        public float score() throws IOException {
            assert (this.docID() != Integer.MAX_VALUE);
            return 0.0f;
        }

        public int docID() {
            return this.docIdsIter.docID();
        }

        public boolean equals(Object obj) {
            return obj instanceof Scorer;
        }
    };

    public KNNScorer(DocIdSetIterator docIdsIter, Map<Integer, Float> scores, float boost) {
        this.docIdsIter = docIdsIter;
        this.scores = scores;
        this.boost = boost;
    }

    public DocIdSetIterator iterator() {
        return this.docIdsIter;
    }

    public float getMaxScore(int upTo) throws IOException {
        return Float.MAX_VALUE;
    }

    public float score() {
        assert (this.docID() != Integer.MAX_VALUE);
        Float score = this.scores.get(this.docID());
        if (score == null) {
            throw new RuntimeException("Null score for the docID: " + this.docID());
        }
        return score.floatValue() * this.boost;
    }

    public int docID() {
        return this.docIdsIter.docID();
    }

    public static Scorer emptyScorer() {
        return EMPTY_SCORER_INSTANCE;
    }
}

