/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.KnnCollector;
import org.opensearch.knn.index.codec.KNN990Codec.QuantizationConfigKNNCollector;
import org.opensearch.knn.index.quantizationservice.QuantizationService;
import org.opensearch.knn.index.query.SegmentLevelQuantizationInfo;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationState;

public final class SegmentLevelQuantizationUtil {
    public static byte[] quantizeVector(float[] vector, SegmentLevelQuantizationInfo segmentLevelQuantizationInfo) {
        if (segmentLevelQuantizationInfo == null) {
            return null;
        }
        QuantizationService quantizationService = QuantizationService.getInstance();
        return (byte[])quantizationService.quantize(segmentLevelQuantizationInfo.getQuantizationState(), vector, quantizationService.createQuantizationOutput(segmentLevelQuantizationInfo.getQuantizationParams()));
    }

    static QuantizationState getQuantizationState(LeafReader leafReader, String fieldName) throws IOException {
        QuantizationConfigKNNCollector tempCollector = new QuantizationConfigKNNCollector();
        leafReader.searchNearestVectors(fieldName, new float[0], (KnnCollector)tempCollector, null);
        if (tempCollector.getQuantizationState() == null) {
            throw new IllegalStateException(String.format(Locale.ROOT, "No quantization state found for field %s", fieldName));
        }
        return tempCollector.getQuantizationState();
    }

    private SegmentLevelQuantizationUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

