/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.iterators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;

public class GroupedNestedDocIdSetIterator
extends DocIdSetIterator {
    private final BitSet parentBitSet;
    private final Bits filterBits;
    private final List<Integer> docIds;
    private long cost;
    private int currentIndex;
    private int currentDocId;
    private int currentParentId;

    public GroupedNestedDocIdSetIterator(BitSet parentBitSet, Set<Integer> docIds, Bits filterBits) {
        this.parentBitSet = parentBitSet;
        this.docIds = new ArrayList<Integer>(docIds);
        this.docIds.sort(Comparator.naturalOrder());
        this.filterBits = filterBits;
        this.currentIndex = -1;
        this.currentDocId = -1;
        this.cost = -1L;
    }

    public int docID() {
        return this.currentDocId;
    }

    public int nextDoc() throws IOException {
        while (this.doNextDoc() != Integer.MAX_VALUE) {
            if (!this.filterBits.get(this.currentDocId)) continue;
            return this.currentDocId;
        }
        return this.currentDocId;
    }

    public int doNextDoc() throws IOException {
        if (this.currentDocId == Integer.MAX_VALUE) {
            return this.currentDocId;
        }
        if (this.currentDocId == -1) {
            this.moveToNextIndex();
            return this.currentDocId;
        }
        ++this.currentDocId;
        assert (this.currentDocId <= this.currentParentId);
        if (this.currentDocId == this.currentParentId) {
            this.moveToNextIndex();
        }
        return this.currentDocId;
    }

    public int advance(int i) throws IOException {
        if (this.currentDocId == Integer.MAX_VALUE) {
            return this.currentDocId;
        }
        return this.slowAdvance(i);
    }

    public long cost() {
        if (this.cost == -1L) {
            this.cost = this.calculateCost();
        }
        return this.cost;
    }

    private long calculateCost() {
        long numDocs = 0L;
        for (int docId : this.docIds) {
            for (int i = this.parentBitSet.prevSetBit(docId) + 1; i < this.parentBitSet.nextSetBit(docId); ++i) {
                if (!this.filterBits.get(i)) continue;
                ++numDocs;
            }
        }
        return numDocs;
    }

    private void moveToNextIndex() {
        ++this.currentIndex;
        if (this.currentIndex >= this.docIds.size()) {
            this.currentDocId = Integer.MAX_VALUE;
            return;
        }
        this.currentDocId = this.parentBitSet.prevSetBit(this.docIds.get(this.currentIndex).intValue()) + 1;
        this.currentParentId = this.parentBitSet.nextSetBit(this.docIds.get(this.currentIndex).intValue());
        assert (this.currentParentId != Integer.MAX_VALUE);
    }
}

