/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.lucene;

import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class LuceneEngineKnnVectorQuery
extends Query {
    private final Query luceneQuery;

    public LuceneEngineKnnVectorQuery(Query luceneQuery) {
        this.luceneQuery = luceneQuery;
    }

    public Query rewrite(IndexSearcher indexSearcher) {
        return this;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        Query rewrittenQuery = this.luceneQuery.rewrite(searcher);
        return rewrittenQuery.createWeight(searcher, scoreMode, boost);
    }

    public String toString(String s) {
        return this.luceneQuery.toString();
    }

    public void visit(QueryVisitor queryVisitor) {
        queryVisitor.visitLeaf((Query)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LuceneEngineKnnVectorQuery otherQuery = (LuceneEngineKnnVectorQuery)((Object)o);
        return this.luceneQuery.equals((Object)otherQuery.luceneQuery);
    }

    public int hashCode() {
        return this.luceneQuery.hashCode();
    }

    public Query getLuceneQuery() {
        return this.luceneQuery;
    }
}

