/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.lucenelib;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.KnnFloatVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.DiversifyingChildrenFloatKnnVectorQuery;
import org.opensearch.knn.index.query.lucenelib.InternalNestedKnnVectorQuery;

public class InternalNestedKnnFloatVectoryQuery
extends KnnFloatVectorQuery
implements InternalNestedKnnVectorQuery {
    private final String field;
    private final float[] target;
    private final Query filter;
    private final int k;
    private final BitSetProducer parentFilter;
    private final DiversifyingChildrenFloatKnnVectorQuery diversifyingChildrenFloatKnnVectorQuery;

    public InternalNestedKnnFloatVectoryQuery(String field, float[] target, Query filter, int k, BitSetProducer parentFilter) {
        super(field, target, Integer.MAX_VALUE, filter);
        this.field = field;
        this.target = target;
        this.filter = filter;
        this.k = k;
        this.parentFilter = parentFilter;
        this.diversifyingChildrenFloatKnnVectorQuery = new DiversifyingChildrenFloatKnnVectorQuery(field, target, filter, k, parentFilter);
    }

    @Override
    public Query knnRewrite(IndexSearcher searcher) throws IOException {
        return this.diversifyingChildrenFloatKnnVectorQuery.rewrite(searcher);
    }

    @Override
    public TopDocs knnExactSearch(LeafReaderContext context, DocIdSetIterator acceptIterator) throws IOException {
        return super.exactSearch(context, acceptIterator, null);
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public Query getFilter() {
        return this.filter;
    }

    @Override
    public int getK() {
        return this.k;
    }

    @Override
    public BitSetProducer getParentFilter() {
        return this.parentFilter;
    }
}

