/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.parser;

import io.skylite.common.ValidationException;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.knn.index.query.KNNQueryBuilder;
import org.opensearch.knn.index.query.request.MethodParameter;

public class MethodParametersParser {
    public static ValidationException validateMethodParameters(Map<String, ?> methodParameters) {
        ArrayList<Object> errors = new ArrayList<Object>();
        for (Map.Entry<String, ?> methodParameter : methodParameters.entrySet()) {
            MethodParameter parameter = MethodParameter.enumOf(methodParameter.getKey());
            if (parameter != null) {
                ValidationException validationException = parameter.validate(methodParameter.getValue());
                if (validationException == null) continue;
                errors.add(validationException.getMessage());
                continue;
            }
            errors.add(methodParameter.getKey() + " is not a valid method parameter");
        }
        if (!errors.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(errors);
            return validationException;
        }
        return null;
    }

    public static Map<String, ?> streamInput(StreamInput in, Function<String, Boolean> minClusterVersionCheck) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        HashMap methodParameters = new HashMap();
        for (MethodParameter methodParameter : MethodParameter.values()) {
            if (!minClusterVersionCheck.apply(methodParameter.getName()).booleanValue()) continue;
            String name = in.readString();
            Object value = in.readGenericValue();
            if (value == null) continue;
            methodParameters.put(name, methodParameter.parse(value));
        }
        return !methodParameters.isEmpty() ? methodParameters : null;
    }

    public static void streamOutput(StreamOutput out, Map<String, ?> methodParameters, Function<String, Boolean> minClusterVersionCheck) throws IOException {
        if (methodParameters == null || methodParameters.isEmpty()) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            for (MethodParameter methodParameter : MethodParameter.values()) {
                if (!minClusterVersionCheck.apply(methodParameter.getName()).booleanValue()) continue;
                out.writeString(methodParameter.getName());
                out.writeGenericValue(methodParameters.get(methodParameter.getName()));
            }
        }
    }

    public static void doXContent(XContentBuilder builder, Map<String, ?> methodParameters) throws IOException {
        if (methodParameters == null || methodParameters.isEmpty()) {
            return;
        }
        builder.startObject(KNNQueryBuilder.METHOD_PARAMS_FIELD.getPreferredName());
        for (Map.Entry<String, ?> entry : methodParameters.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            builder.field(entry.getKey(), entry.getValue());
        }
        builder.endObject();
    }

    public static Map<String, ?> fromXContent(XContentParser parser) throws IOException {
        Map methodParametersJson = parser.map();
        if (methodParametersJson.isEmpty()) {
            throw new ParsingException(parser.getTokenLocation(), KNNQueryBuilder.METHOD_PARAMS_FIELD.getPreferredName() + " cannot be empty", new Object[0]);
        }
        HashMap methodParameters = new HashMap();
        for (Map.Entry requestParameter : methodParametersJson.entrySet()) {
            String name = (String)requestParameter.getKey();
            Object value = requestParameter.getValue();
            MethodParameter parameter = MethodParameter.enumOf(name);
            if (parameter == null) {
                throw new ParsingException(parser.getTokenLocation(), "[knn] unknown method parameter found [" + name + "]", new Object[0]);
            }
            try {
                methodParameters.put(name, parameter.parse(value));
            }
            catch (Exception exception) {
                throw new ParsingException(parser.getTokenLocation(), exception.getMessage(), new Object[0]);
            }
        }
        return methodParameters.isEmpty() ? null : methodParameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodParametersParser)) {
            return false;
        }
        MethodParametersParser other = (MethodParametersParser)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof MethodParametersParser;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

