/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.request;

import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.common.ValidationException;
import io.skylite.core.ParseField;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.knn.index.query.KNNQueryBuilder;

public enum MethodParameter {
    EF_SEARCH("ef_search", (Version)OpenSearchVersion.fromId((int)2160099), KNNQueryBuilder.EF_SEARCH_FIELD){

        public Integer parse(Object value) {
            return MethodParameter.parseInteger(value, "ef_search");
        }

        @Override
        public ValidationException validate(Object value) {
            Integer ef = this.parse(value);
            if (ef != null && ef > 0) {
                return null;
            }
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("ef_search should be greater than 0");
            return validationException;
        }
    }
    ,
    NPROBE("nprobes", (Version)OpenSearchVersion.fromId((int)2160099), KNNQueryBuilder.NPROBE_FIELD){

        public Integer parse(Object value) {
            return MethodParameter.parseInteger(value, "ef_search");
        }

        @Override
        public ValidationException validate(Object value) {
            Integer nprobe = this.parse(value);
            if (nprobe != null && nprobe > 0) {
                return null;
            }
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("nprobes should be greater than 0");
            return validationException;
        }
    };

    private final String name;
    private final Version version;
    private final ParseField parseField;
    private static Map<String, MethodParameter> PARAMETERS_DIR;

    private MethodParameter(String name, Version version, ParseField parseField) {
        this.name = name;
        this.version = version;
        this.parseField = parseField;
    }

    public abstract <T> T parse(Object var1);

    public abstract ValidationException validate(Object var1);

    public static MethodParameter enumOf(String name) {
        if (PARAMETERS_DIR == null) {
            PARAMETERS_DIR = new HashMap<String, MethodParameter>();
            for (MethodParameter methodParameter : MethodParameter.values()) {
                PARAMETERS_DIR.put(methodParameter.name, methodParameter);
            }
        }
        return PARAMETERS_DIR.get(name);
    }

    private static Integer parseInteger(Object value, String name) {
        try {
            return Integer.parseInt(String.valueOf(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(name + " value must be an integer");
        }
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }
}

