/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.util;

import io.skylite.Version;
import io.skylite.core.cluster.service.ClusterService;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KNNClusterUtil {
    private static final Logger log = LogManager.getLogger(KNNClusterUtil.class);
    private ClusterService clusterService;
    private static KNNClusterUtil instance;

    private KNNClusterUtil() {
    }

    public static synchronized KNNClusterUtil instance() {
        if (instance == null) {
            instance = new KNNClusterUtil();
        }
        return instance;
    }

    public void initialize(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public Version getClusterMinVersion() {
        try {
            return this.clusterService.state().getNodes().getMinNodeVersion();
        }
        catch (Exception exception) {
            log.error(String.format(Locale.ROOT, "Failed to get cluster minimum node version, returning current node version %s instead.", Version.CURRENT), (Throwable)exception);
            return Version.CURRENT;
        }
    }
}

