/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.vectorvalues;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.KnnVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValuesIterator;
import org.opensearch.knn.index.vectorvalues.VectorValueExtractorStrategy;

public class KNNByteVectorValues
extends KNNVectorValues<byte[]> {
    KNNByteVectorValues(KNNVectorValuesIterator vectorValuesIterator) {
        super(vectorValuesIterator);
    }

    @Override
    public byte[] getVector() throws IOException {
        byte[] vector = VectorValueExtractorStrategy.extractByteVector(this.vectorValuesIterator);
        this.dimension = vector.length;
        this.bytesPerVector = vector.length;
        return vector;
    }

    @Override
    public byte[] conditionalCloneVector() throws IOException {
        byte[] vector = this.getVector();
        if (this.vectorValuesIterator.getDocIdSetIterator() instanceof KnnVectorValues.DocIndexIterator) {
            return Arrays.copyOf(vector, vector.length);
        }
        return vector;
    }

    @Override
    public String toString() {
        return "KNNByteVectorValues(super=" + super.toString() + ")";
    }
}

