/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.indices;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;

public enum ModelState implements Writeable
{
    TRAINING("training"),
    CREATED("created"),
    FAILED("failed");

    private final String name;

    private ModelState(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        streamOutput.writeString(this.getName());
    }

    public static ModelState readFrom(StreamInput in) throws IOException {
        return ModelState.getModelState(in.readString());
    }

    public static ModelState getModelState(String name) {
        if (TRAINING.getName().equals(name)) {
            return TRAINING;
        }
        if (CREATED.getName().equals(name)) {
            return CREATED;
        }
        if (FAILED.getName().equals(name)) {
            return FAILED;
        }
        throw new IllegalArgumentException("Unable to find model state: \"" + name + "\"");
    }
}

