/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.rest;

import com.google.common.collect.ImmutableList;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.IntConsumer;
import org.opensearch.knn.common.KNNConstants;
import org.opensearch.knn.plugin.transport.SearchModelAction;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestCancellableNodeClient;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.rest.action.search.RestSearchAction;

public class RestSearchModelHandler
extends BaseRestHandler {
    private static final String NAME = "knn_search_model_action";
    private static final String SEARCH = "_search";
    public List<String> UNSUPPORTED_PARAM_LIST = Arrays.asList("index");

    public String getName() {
        return NAME;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/%s/%s", "/_plugins/_knn", "models", SEARCH)), (Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/%s/%s", "/_plugins/_knn", "models", SEARCH)));
    }

    private void checkUnSupportedParamsExists(RestRequest request) {
        ArrayList invalidParam = new ArrayList();
        this.UNSUPPORTED_PARAM_LIST.forEach(param -> {
            if (request.hasParam(param)) {
                invalidParam.add(param);
            }
        });
        if (invalidParam.isEmpty()) {
            return;
        }
        String errorMessage = "request contains an unrecognized parameter: [ " + String.join((CharSequence)",", invalidParam) + " ]";
        throw new IllegalArgumentException(errorMessage);
    }

    private void validateSizeParameter(RestRequest request) {
        if (!request.hasParam("size")) {
            return;
        }
        if (this.isSearchSizeValueValid(request.paramAsInt("size", 1))) {
            return;
        }
        throw new IllegalArgumentException(String.format("%s must be between %d and %d inclusive", "size", KNNConstants.SEARCH_MODEL_MIN_SIZE, KNNConstants.SEARCH_MODEL_MAX_SIZE));
    }

    private boolean isSearchSizeValueValid(int searchSize) {
        return searchSize >= KNNConstants.SEARCH_MODEL_MIN_SIZE && searchSize <= KNNConstants.SEARCH_MODEL_MAX_SIZE;
    }

    private void validateRequest(RestRequest request) {
        this.checkUnSupportedParamsExists(request);
        this.validateSizeParameter(request);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        this.validateRequest(request);
        SearchRequest searchRequest = new SearchRequest();
        IntConsumer setSize = size -> searchRequest.source().size(size);
        request.withContentOrSourceParamParserOrNull(parser -> RestSearchAction.parseSearchRequest((SearchRequest)searchRequest, (RestRequest)request, (XContentParser)parser, (NamedWriteableRegistry)client.getNamedWriteableRegistry(), (IntConsumer)setSize));
        return channel -> {
            RestCancellableNodeClient cancelClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancelClient.execute((ActionType)SearchModelAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)new RestToXContentListener(channel));
        };
    }
}

