/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.plugin.transport.GetModelRequest;
import org.opensearch.knn.plugin.transport.GetModelResponse;

public class GetModelTransportAction
extends HandledTransportAction<GetModelRequest, GetModelResponse> {
    private ModelDao modelDao = ModelDao.OpenSearchKNNModelDao.getInstance();

    @Inject
    public GetModelTransportAction(TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/knn_get_model_action", transportService, actionFilters, GetModelRequest::new);
    }

    protected void doExecute(Task task, GetModelRequest request, ActionListener<GetModelResponse> actionListener) {
        String modelID = request.getModelID();
        this.modelDao.get(modelID, actionListener);
    }
}

