/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import io.lucenia.action.support.broadcast.node.TransportBroadcastByNodeAction;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.ShardsIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.indices.IndicesService;
import org.opensearch.knn.index.KNNIndexShard;
import org.opensearch.knn.plugin.transport.KNNWarmupRequest;
import org.opensearch.knn.plugin.transport.KNNWarmupResponse;

public class KNNWarmupTransportAction
extends TransportBroadcastByNodeAction<KNNWarmupRequest, KNNWarmupResponse, TransportBroadcastByNodeAction.EmptyResult> {
    public static Logger logger = LogManager.getLogger(KNNWarmupTransportAction.class);
    private IndicesService indicesService;

    @Inject
    public KNNWarmupTransportAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/knn_warmup_action", clusterService, transportService, actionFilters, indexNameExpressionResolver, KNNWarmupRequest::new, "search");
        this.indicesService = indicesService;
    }

    protected TransportBroadcastByNodeAction.EmptyResult readShardResult(StreamInput in) throws IOException {
        return TransportBroadcastByNodeAction.EmptyResult.readEmptyResultFrom((StreamInput)in);
    }

    protected KNNWarmupResponse newResponse(KNNWarmupRequest request, int totalShards, int successfulShards, int failedShards, List<TransportBroadcastByNodeAction.EmptyResult> emptyResults, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new KNNWarmupResponse(totalShards, successfulShards, failedShards, shardFailures);
    }

    protected KNNWarmupRequest readRequestFrom(StreamInput in) throws IOException {
        return new KNNWarmupRequest(in);
    }

    protected TransportBroadcastByNodeAction.EmptyResult shardOperation(KNNWarmupRequest request, ShardRouting shardRouting) throws IOException {
        KNNIndexShard knnIndexShard = new KNNIndexShard((BaseIndexShard)this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex()).getShard(shardRouting.shardId().id()));
        knnIndexShard.warmup();
        return TransportBroadcastByNodeAction.EmptyResult.INSTANCE;
    }

    protected ShardsIterator shards(ClusterState state, KNNWarmupRequest request, String[] concreteIndices) {
        return state.routingTable().allShards(concreteIndices);
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState state, KNNWarmupRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, KNNWarmupRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }
}

