/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateTaskExecutor;
import io.skylite.core.cluster.state.ClusterStateTaskListener;
import io.skylite.core.common.Priority;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.knn.indices.ModelMetadata;
import org.opensearch.knn.plugin.transport.UpdateModelMetadataRequest;

public class UpdateModelMetadataTransportAction
extends TransportClusterManagerNodeAction<UpdateModelMetadataRequest, AcknowledgedResponse> {
    public static Logger logger = LogManager.getLogger(UpdateModelMetadataTransportAction.class);
    private UpdateModelMetadataExecutor updateModelMetadataExecutor = new UpdateModelMetadataExecutor();

    @Inject
    public UpdateModelMetadataTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/knn_update_model_metadata_action", transportService, clusterService, threadPool, actionFilters, UpdateModelMetadataRequest::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput streamInput) throws IOException {
        return new AcknowledgedResponse(streamInput);
    }

    protected void clusterManagerOperation(UpdateModelMetadataRequest request, ClusterState clusterState, final ActionListener<AcknowledgedResponse> actionListener) {
        this.clusterService.submitStateUpdateTask("knn", (Object)new UpdateModelMetaDataTask(request.getModelId(), request.getModelMetadata(), request.isRemoveRequest()), ClusterStateTaskConfig.build((Priority)Priority.NORMAL), (ClusterStateTaskExecutor)this.updateModelMetadataExecutor, new ClusterStateTaskListener(){

            public void onFailure(String s, Exception e) {
                actionListener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                actionListener.onResponse((Object)new AcknowledgedResponse(true));
            }
        });
    }

    protected ClusterBlockException checkBlock(UpdateModelMetadataRequest request, ClusterState clusterState) {
        return null;
    }

    private static class UpdateModelMetadataExecutor
    implements ClusterStateTaskExecutor<UpdateModelMetaDataTask> {
        private UpdateModelMetadataExecutor() {
        }

        public ClusterStateTaskExecutor.ClusterStateTasksResult<UpdateModelMetaDataTask> execute(ClusterState clusterState, List<UpdateModelMetaDataTask> list) {
            IndexMetadata indexMetadata = clusterState.metadata().index(".lucenia-knn-models");
            if (indexMetadata == null) {
                throw new RuntimeException("Model index's metadata does not exist");
            }
            Map immutableModels = indexMetadata.getCustomData("knn-models");
            HashMap<String, String> models = immutableModels == null ? new HashMap<String, String>() : new HashMap(immutableModels);
            for (UpdateModelMetaDataTask task : list) {
                if (task.isRemoveRequest) {
                    models.remove(task.modelId);
                    continue;
                }
                models.put(task.modelId, task.modelMetadata.toString());
            }
            Metadata.Builder metaDataBuilder = Metadata.builder((Metadata)clusterState.metadata());
            metaDataBuilder.put(IndexMetadata.builder((IndexMetadata)indexMetadata).putCustom("knn-models", models));
            ClusterState updatedClusterState = ClusterState.builder((ClusterState)clusterState).metadata(metaDataBuilder).build();
            return new ClusterStateTaskExecutor.ClusterStateTasksResult.Builder().successes(list).build(updatedClusterState);
        }
    }

    private static class UpdateModelMetaDataTask {
        private String modelId;
        private ModelMetadata modelMetadata;
        private boolean isRemoveRequest;

        UpdateModelMetaDataTask(String modelId, ModelMetadata modelMetadata, boolean isRemoveRequest) {
            this.modelId = modelId;
            this.modelMetadata = modelMetadata;
            this.isRemoveRequest = isRemoveRequest;
        }
    }
}

