/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.quantization.models.quantizationParams;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;
import java.util.Objects;
import org.opensearch.knn.quantization.enums.ScalarQuantizationType;
import org.opensearch.knn.quantization.models.quantizationParams.QuantizationParams;

public class ScalarQuantizationParams
implements QuantizationParams {
    private ScalarQuantizationType sqType;

    public ScalarQuantizationParams(ScalarQuantizationType sqType) {
        this.sqType = sqType;
    }

    public ScalarQuantizationParams() {
    }

    public static String generateTypeIdentifier(ScalarQuantizationType sqType) {
        return ScalarQuantizationParams.generateIdentifier(sqType.getId());
    }

    @Override
    public String getTypeIdentifier() {
        return ScalarQuantizationParams.generateIdentifier(this.sqType.getId());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.sqType.getId());
    }

    public ScalarQuantizationParams(StreamInput in, int version) throws IOException {
        int typeId = in.readVInt();
        this.sqType = ScalarQuantizationType.fromId(typeId);
    }

    private static String generateIdentifier(int id) {
        return "ScalarQuantizationParams_" + id;
    }

    public ScalarQuantizationType getSqType() {
        return this.sqType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScalarQuantizationParams)) {
            return false;
        }
        ScalarQuantizationParams other = (ScalarQuantizationParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScalarQuantizationType this_sqType = this.getSqType();
        ScalarQuantizationType other_sqType = other.getSqType();
        return Objects.equals((Object)this_sqType, (Object)other_sqType);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScalarQuantizationParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScalarQuantizationType $sqType = this.getSqType();
        result = result * 59 + ($sqType == null ? 43 : ((Object)((Object)$sqType)).hashCode());
        return result;
    }
}

