/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.quantization.models.quantizationState;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalNotification;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.unit.ByteSizeValue;
import java.io.IOException;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationState;

public class QuantizationStateCache {
    private static final Logger log = LogManager.getLogger(QuantizationStateCache.class);
    private static volatile QuantizationStateCache instance;
    private Cache<String, QuantizationState> cache;
    private long maxCacheSizeInKB = ((ByteSizeValue)KNNSettings.state().getSettingValue("knn.quantization.cache.size.limit")).getKb();
    private Instant evictedDueToSizeAt;

    @VisibleForTesting
    QuantizationStateCache() {
        this.buildCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static QuantizationStateCache getInstance() {
        if (instance != null) return instance;
        Class<QuantizationStateCache> clazz = QuantizationStateCache.class;
        synchronized (QuantizationStateCache.class) {
            if (instance != null) return instance;
            instance = new QuantizationStateCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void buildCache() {
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumWeight(this.maxCacheSizeInKB).weigher((k, v) -> {
            try {
                return ((QuantizationState)v).toByteArray().length;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).expireAfterAccess(((TimeValue)KNNSettings.state().getSettingValue("knn.quantization.cache.expiry.minutes")).getMinutes(), TimeUnit.MINUTES).removalListener(this::onRemoval).build();
    }

    synchronized void rebuildCache() {
        this.clear();
        this.buildCache();
    }

    QuantizationState getQuantizationState(String fieldName) {
        return (QuantizationState)this.cache.getIfPresent((Object)fieldName);
    }

    void addQuantizationState(String fieldName, QuantizationState quantizationState) {
        this.cache.put((Object)fieldName, (Object)quantizationState);
    }

    public void evict(String fieldName) {
        this.cache.invalidate((Object)fieldName);
    }

    private void onRemoval(RemovalNotification<String, QuantizationState> removalNotification) {
        if (RemovalCause.SIZE == removalNotification.getCause()) {
            this.updateEvictedDueToSizeAt();
            log.info("[KNN] Quantization state evicted from cache. Key {}, Reason: {}", removalNotification.getKey(), (Object)removalNotification.getCause());
        }
    }

    void setMaxCacheSizeInKB(long maxCacheSizeInKB) {
        this.maxCacheSizeInKB = maxCacheSizeInKB;
    }

    private void updateEvictedDueToSizeAt() {
        this.evictedDueToSizeAt = Instant.now();
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public long getMaxCacheSizeInKB() {
        return this.maxCacheSizeInKB;
    }

    public Instant getEvictedDueToSizeAt() {
        return this.evictedDueToSizeAt;
    }
}

