/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.quantization.quantizer;

import java.io.IOException;
import org.opensearch.knn.quantization.models.requests.TrainingRequest;
import oshi.util.tuples.Pair;

final class QuantizerHelper {
    QuantizerHelper() {
    }

    static float[] calculateMeanThresholds(TrainingRequest<float[]> samplingRequest, int[] sampledIndices) throws IOException {
        int totalSamples = sampledIndices.length;
        float[] mean = null;
        boolean lastIndex = false;
        for (int docId : sampledIndices) {
            float[] vector = samplingRequest.getVectorAtThePosition(docId);
            if (vector == null) {
                throw new IllegalArgumentException("Vector at sampled index " + docId + " is null.");
            }
            if (mean == null) {
                mean = new float[vector.length];
            }
            for (int j = 0; j < vector.length; ++j) {
                int n = j;
                mean[n] = mean[n] + vector[j];
            }
        }
        if (mean == null) {
            throw new IllegalStateException("Mean array should not be null after processing vectors.");
        }
        int j = 0;
        while (j < mean.length) {
            int n = j++;
            mean[n] = mean[n] / (float)totalSamples;
        }
        return mean;
    }

    static Pair<float[], float[]> calculateMeanAndStdDev(TrainingRequest<float[]> trainingRequest, int[] sampledIndices) throws IOException {
        float[] meanArray = null;
        float[] stdDevArray = null;
        int totalSamples = sampledIndices.length;
        boolean lastIndex = false;
        for (int docId : sampledIndices) {
            float[] vector = trainingRequest.getVectorAtThePosition(docId);
            if (vector == null) {
                throw new IllegalArgumentException("Vector at sampled index " + docId + " is null.");
            }
            int dimension = vector.length;
            if (meanArray == null) {
                meanArray = new float[dimension];
            }
            if (stdDevArray == null) {
                stdDevArray = new float[dimension];
            }
            for (int j = 0; j < dimension; ++j) {
                int n = j;
                meanArray[n] = meanArray[n] + vector[j];
                int n2 = j;
                stdDevArray[n2] = stdDevArray[n2] + vector[j] * vector[j];
            }
        }
        if (meanArray == null || stdDevArray == null) {
            throw new IllegalStateException("Mean and StdDev should not be null after processing vectors.");
        }
        for (int j = 0; j < meanArray.length; ++j) {
            meanArray[j] = meanArray[j] / (float)totalSamples;
            stdDevArray[j] = (float)Math.sqrt(stdDevArray[j] / (float)totalSamples - meanArray[j] * meanArray[j]);
        }
        return new Pair(meanArray, stdDevArray);
    }
}

