/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Map;

public class ToolMetadata
implements ToXContentObject,
Writeable {
    public static final String TOOL_NAME_FIELD = "name";
    public static final String TOOL_DESCRIPTION_FIELD = "description";
    public static final String TOOL_TYPE_FIELD = "type";
    public static final String TOOL_VERSION_FIELD = "version";
    public static final String TOOL_ATTRIBUTES_FIELD = "attributes";
    private String name;
    private String description;
    private String type;
    private String version;
    private Map<String, Object> attributes;

    public ToolMetadata(String name, String description, String type, String version, Map<String, Object> attributes) {
        this.name = name;
        this.description = description;
        this.type = type;
        this.version = version;
        this.attributes = attributes;
    }

    public ToolMetadata(StreamInput input) throws IOException {
        this.name = input.readString();
        this.description = input.readString();
        this.type = input.readString();
        this.version = input.readOptionalString();
        this.attributes = input.readMap(StreamInput::readString, StreamInput::readGenericValue);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().name(this.name).description(this.description).type(this.type).version(this.version);
    }

    public void writeTo(StreamOutput output) throws IOException {
        output.writeString(this.name);
        output.writeString(this.description);
        output.writeString(this.type);
        output.writeOptionalString(this.version);
        if (this.attributes != null) {
            output.writeBoolean(true);
            output.writeMap(this.attributes, StreamOutput::writeString, StreamOutput::writeGenericValue);
        } else {
            output.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field(TOOL_NAME_FIELD, this.name);
        }
        if (this.description != null) {
            builder.field(TOOL_DESCRIPTION_FIELD, this.description);
        }
        if (this.type != null) {
            builder.field(TOOL_TYPE_FIELD, this.type);
        }
        builder.field(TOOL_VERSION_FIELD, this.version != null ? this.version : "undefined");
        if (this.attributes != null) {
            builder.field(TOOL_ATTRIBUTES_FIELD, this.attributes);
        }
        builder.endObject();
        return builder;
    }

    public static ToolMetadata parse(XContentParser parser) throws IOException {
        String name = null;
        String description = null;
        String type = null;
        String version = null;
        Map attributes = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block14;
                }
                case "description": {
                    description = parser.text();
                    continue block14;
                }
                case "type": {
                    type = parser.text();
                    continue block14;
                }
                case "version": {
                    version = parser.text();
                    continue block14;
                }
                case "attributes": {
                    attributes = parser.map();
                    continue block14;
                }
            }
            parser.skipChildren();
        }
        return ToolMetadata.builder().name(name).description(description).type(type).version(version).attributes(attributes).build();
    }

    public static ToolMetadata fromStream(StreamInput in) throws IOException {
        ToolMetadata toolMetadata = new ToolMetadata(in);
        return toolMetadata;
    }

    public static class Builder {
        private String name;
        private String description;
        private String type;
        private String version;
        private Map<String, Object> attributes;

        public ToolMetadata build() {
            return new ToolMetadata(this.name, this.description, this.type, this.version, this.attributes);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder attributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }
    }
}

